/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.impl.scanner;

import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpResponse;
import com.subgraph.vega.api.http.requests.RequestEngineException;
import com.subgraph.vega.api.scanner.IScanProbeResult;
import com.subgraph.vega.impl.scanner.ScanProbeResult;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.util.EntityUtils;

public class ScanProbe {
    private static final int MAX_REDIRECT_COUNT = 5;
    private final URI targetURI;
    private final IHttpRequestEngine requestEngine;
    private volatile HttpUriRequest currentRequest;

    ScanProbe(URI uRI, IHttpRequestEngine iHttpRequestEngine) {
        this.targetURI = uRI;
        this.requestEngine = iHttpRequestEngine;
    }

    IScanProbeResult runProbe() {
        this.currentRequest = this.requestEngine.createGetRequest(URIUtils.extractHost((URI)this.targetURI), this.getPathAndQuery(this.targetURI));
        try {
            IHttpResponse iHttpResponse = this.requestEngine.sendRequest(this.currentRequest).get(true);
            return this.processFirstProbeResponse(this.targetURI, iHttpResponse);
        }
        catch (RequestEngineException requestEngineException) {
            requestEngineException.printStackTrace();
            return ScanProbeResult.createConnectFailedResult(requestEngineException.getMessage());
        }
    }

    private String getPathAndQuery(URI uRI) {
        if (uRI.getQuery() != null) {
            return String.valueOf(uRI.getPath()) + '?' + uRI.getQuery();
        }
        return uRI.getPath();
    }

    private IScanProbeResult processFirstProbeResponse(URI uRI, IHttpResponse iHttpResponse) {
        if (this.isResponseRedirect(iHttpResponse)) {
            return this.processRedirect(uRI, iHttpResponse);
        }
        return ScanProbeResult.createOkResult();
    }

    private boolean isResponseRedirect(IHttpResponse iHttpResponse) {
        int n = iHttpResponse.getResponseCode();
        return n == 301 || n == 302 || n == 303 || n == 307;
    }

    private IScanProbeResult processRedirect(URI uRI, IHttpResponse iHttpResponse) {
        int n = 1;
        while (n < 5) {
            URI uRI2 = this.getLocationURI(iHttpResponse);
            if (uRI2 == null) {
                return ScanProbeResult.createRedirectFailedResult("Target address redirected to a location which could not be understood");
            }
            try {
                this.currentRequest = this.requestEngine.createGetRequest(URIUtils.extractHost((URI)uRI2), this.getPathAndQuery(uRI2));
                iHttpResponse = this.requestEngine.sendRequest(this.currentRequest).get(true);
                EntityUtils.consumeQuietly((HttpEntity)iHttpResponse.getRawResponse().getEntity());
                if (!this.isResponseRedirect(iHttpResponse)) {
                    return ScanProbeResult.createRedirectResult(uRI2);
                }
            }
            catch (RequestEngineException requestEngineException) {
                return ScanProbeResult.createRedirectFailedResult(this.createRedirectExceptionMessage(uRI, uRI2, (Exception)((Object)requestEngineException)));
            }
            ++n;
        }
        return ScanProbeResult.createConnectFailedResult("Could not connect to target because maximum redirection limit reached");
    }

    private String createRedirectExceptionMessage(URI uRI, URI uRI2, Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Target address ");
        stringBuilder.append(uRI.toString());
        stringBuilder.append(" redirected to address ");
        stringBuilder.append(uRI2.toString());
        stringBuilder.append(" which was not reachable");
        stringBuilder.append(exception.getMessage());
        return stringBuilder.toString();
    }

    private URI getLocationURI(IHttpResponse iHttpResponse) {
        Header header = iHttpResponse.getRawResponse().getFirstHeader("Location");
        if (header == null) {
            return null;
        }
        return iHttpResponse.getRequestUri().resolve(header.getValue());
    }

    void abort() {
        HttpUriRequest httpUriRequest = this.currentRequest;
        if (httpUriRequest != null) {
            httpUriRequest.abort();
        }
    }
}

