/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.identity.identitywizard;

import com.subgraph.vega.api.model.identity.IAuthMethod;
import com.subgraph.vega.api.model.identity.IAuthMethodHttpMacro;
import com.subgraph.vega.api.model.macros.IHttpMacro;
import com.subgraph.vega.ui.identity.Activator;
import com.subgraph.vega.ui.identity.identitywizard.IAuthMethodControl;
import com.subgraph.vega.ui.identity.identitywizard.MacrosTableContentProvider;
import com.subgraph.vega.ui.macros.macrodialog.MacroDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class AuthMethodControlHttpMacro
extends Composite
implements IAuthMethodControl {
    private final WizardPage page;
    private IAuthMethodHttpMacro authMethod;
    private TableViewer macrosTableViewer;

    AuthMethodControlHttpMacro(Composite composite, WizardPage wizardPage) {
        super(composite, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.page = wizardPage;
        this.authMethod = Activator.getDefault().getModel().getCurrentWorkspace().getIdentityModel().createAuthMethodHttpMacro();
        this.createControls();
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public IAuthMethod getAuthMethod() {
        IHttpMacro iHttpMacro = (IHttpMacro)((IStructuredSelection)this.macrosTableViewer.getSelection()).getFirstElement();
        this.authMethod.setMacro(iHttpMacro);
        return this.authMethod;
    }

    private void createControls() {
        Label label = new Label((Composite)this, 0);
        label.setText("Select a macro below, or create one");
        this.createMacrosTable(this).setLayoutData((Object)new GridData(1808));
        this.createMacrosTableButtons(this).setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.macrosTableViewer.setInput((Object)Activator.getDefault().getModel().getCurrentWorkspace().getHttpMacroModel());
    }

    private Composite createMacrosTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.macrosTableViewer = new TableViewer(composite2, 68354);
        this.macrosTableViewer.setContentProvider((IContentProvider)new MacrosTableContentProvider());
        this.macrosTableViewer.addSelectionChangedListener(this.createMacrosTableSelectionChangedListener());
        this.createMacrosTableColumns(this.macrosTableViewer, tableColumnLayout);
        Table table = this.macrosTableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        return composite2;
    }

    private ISelectionChangedListener createMacrosTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AuthMethodControlHttpMacro.this.page.setPageComplete(!selectionChangedEvent.getSelection().isEmpty());
            }
        };
    }

    private void createMacrosTableColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnWeightData(1)};
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpMacro)object).getName();
            }
        }};
        int n = 0;
        while (n < columnLayoutDataArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
    }

    private Control createMacrosTableButtons(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText("Create macro");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MacroDialog macroDialog = MacroDialog.createDialog((Shell)AuthMethodControlHttpMacro.this.getShell());
                if (macroDialog.open() == 0) {
                    AuthMethodControlHttpMacro.this.macrosTableViewer.refresh();
                    AuthMethodControlHttpMacro.this.macrosTableViewer.setSelection((ISelection)new StructuredSelection((Object)macroDialog.getMacro()), true);
                }
            }
        });
        return button;
    }
}

