/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.identity.identitiesview;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.identity.IIdentityModel;
import com.subgraph.vega.ui.identity.Activator;
import com.subgraph.vega.ui.identity.identityview.tree.IdentitiesViewerContentProvider;
import com.subgraph.vega.ui.identity.identityview.tree.IdentitiesViewerLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class IdentitiesView
extends ViewPart {
    public static final String ID = "com.subgraph.vega.views.identity.identities";
    private IIdentityModel identityModel;
    private Composite parentComposite;
    private TreeViewer identitiesViewer;

    public IdentitiesView() {
        IWorkspace iWorkspace = Activator.getDefault().getModel().addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    IdentitiesView.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    IdentitiesView.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    IdentitiesView.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        });
        this.identityModel = iWorkspace.getIdentityModel();
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.identityModel = workspaceOpenEvent.getWorkspace().getIdentityModel();
        this.identitiesViewer.setInput((Object)this.identityModel);
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.identityModel = null;
        this.identitiesViewer.setInput((Object)this.identityModel);
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.identityModel = workspaceResetEvent.getWorkspace().getIdentityModel();
        this.identitiesViewer.setInput((Object)this.identityModel);
    }

    public void createPartControl(Composite composite) {
        this.parentComposite = new Composite(composite, 0);
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.createTreeViewer(this.parentComposite);
        this.identitiesViewer.setInput((Object)this.identityModel);
    }

    public void setFocus() {
        this.parentComposite.setFocus();
    }

    private void createTreeViewer(Composite composite) {
        this.identitiesViewer = new TreeViewer(composite, 770);
        this.identitiesViewer.setContentProvider((IContentProvider)new IdentitiesViewerContentProvider());
        this.identitiesViewer.setLabelProvider((IBaseLabelProvider)new IdentitiesViewerLabelProvider());
    }
}

