/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.identity.identitiesview;

import com.subgraph.vega.api.model.identity.IAuthMethod;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class AuthMethodComboViewer
extends ComboViewer {
    public AuthMethodComboViewer(Composite composite) {
        super(composite, 8);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        AuthMethodSelection[] authMethodSelectionArray = AuthMethodSelection.values();
        this.setInput(authMethodSelectionArray);
        this.setSelection((ISelection)new StructuredSelection((Object)authMethodSelectionArray[0]));
    }

    private ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                return ((AuthMethodSelection)((Object)object)).getName();
            }
        };
    }

    public AuthMethodSelection getAuthMethodSelection() {
        return (AuthMethodSelection)((Object)((IStructuredSelection)this.getSelection()).getFirstElement());
    }

    public static enum AuthMethodSelection {
        AUTH_METHOD_BASIC("basic http authentication", IAuthMethod.AuthMethodType.AUTH_METHOD_RFC2617),
        AUTH_METHOD_DIGEST("digest http authentication", IAuthMethod.AuthMethodType.AUTH_METHOD_RFC2617),
        AUTH_METHOD_NTLM("NTLM", IAuthMethod.AuthMethodType.AUTH_METHOD_NTLM),
        AUTH_METHOD_HTTP_MACRO("macro", IAuthMethod.AuthMethodType.AUTH_METHOD_HTTP_MACRO);

        private String name;
        private IAuthMethod.AuthMethodType authMethodType;

        private AuthMethodSelection(String string2, IAuthMethod.AuthMethodType authMethodType) {
            this.name = string2;
            this.authMethodType = authMethodType;
        }

        public String getName() {
            return this.name;
        }

        public IAuthMethod.AuthMethodType getAuthMethodType() {
            return this.authMethodType;
        }
    }
}

