/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.web.views;

import com.subgraph.vega.api.model.scope.ITargetScopeManager;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.IWebResponse;
import com.subgraph.vega.ui.tree.web.WebModelAdapter;
import com.subgraph.vega.ui.util.ImageCache;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class WebsiteLabelProvider
extends LabelProvider
implements IColorProvider {
    private static final Color UNVISITED_COLOR = new Color((Device)Display.getCurrent(), new RGB(180, 180, 180));
    private static final Color IN_SCOPE_BACKGROUND = new Color((Device)Display.getCurrent(), new RGB(230, 230, 250));
    private static final String WEBSITE = "icons/websites.png";
    private static final String ARCHIVE = "icons/mimetype/archive.png";
    private static final String AUDIO = "icons/mimetype/audio.png";
    private static final String BINARY = "icons/mimetype/binary.png";
    private static final String EXECUTABLE = "icons/mimetype/executable.png.png";
    private static final String FLASH = "icons/mimetype/flash.png";
    private static final String FONT = "icons/mimetype/font.png";
    private static final String HTML = "icons/mimetype/html.png";
    private static final String IMAGE = "icons/mimetype/image.png";
    private static final String PDF = "icons/mimetype/pdf.png";
    private static final String POSTSCRIPT = "icons/mimetype/postscript.png";
    private static final String RSS = "icons/mimetype/rss.png";
    private static final String SCRIPT = "icons/mimetype/script.png";
    private static final String TEXT = "icons/mimetype/text.png";
    private static final String VIDEO = "icons/mimetype/video.png";
    private static final String XML = "icons/mimetype/xml.png";
    private static final String MSWORD = "icons/mimetype/msword.png";
    private static final String PRESENTATION = "icons/mimetype/presentation.png";
    private static final String SPREADSHEET = "icons/mimetype/spreadsheet.png";
    private final ImageCache imageCache = new ImageCache("com.subgraph.vega.ui.web");
    private final WebModelAdapter webAdapter = new WebModelAdapter();
    private ITargetScopeManager scopeManager;

    void setTargetScopeManager(ITargetScopeManager iTargetScopeManager) {
        this.scopeManager = iTargetScopeManager;
    }

    public String getText(Object object) {
        return this.webAdapter.getLabel(object);
    }

    public Image getImage(Object object) {
        if (object instanceof IWebHost) {
            IWebHost iWebHost = (IWebHost)object;
            if (iWebHost.isVisited()) {
                return this.imageCache.get(WEBSITE);
            }
            return this.imageCache.getDisabled(WEBSITE);
        }
        String string = this.getMimeTypeForElement(object);
        return this.getMimeImage(string);
    }

    private String getMimeTypeForElement(Object object) {
        if (object instanceof IWebResponse) {
            return ((IWebResponse)object).getMimeType();
        }
        if (object instanceof IWebPath) {
            return ((IWebPath)object).getMimeType();
        }
        return null;
    }

    public void dispose() {
        this.imageCache.dispose();
        super.dispose();
    }

    public Color getForeground(Object object) {
        if (object instanceof IWebEntity) {
            IWebEntity iWebEntity = (IWebEntity)object;
            return iWebEntity.isVisited() ? null : UNVISITED_COLOR;
        }
        return null;
    }

    public Color getBackground(Object object) {
        if (object instanceof IWebEntity && this.isInScope((IWebEntity)object)) {
            return IN_SCOPE_BACKGROUND;
        }
        return null;
    }

    private boolean isInScope(IWebEntity iWebEntity) {
        if (this.scopeManager == null) {
            return false;
        }
        if (iWebEntity instanceof IWebHost) {
            return this.scopeManager.getActiveScope().filter(((IWebHost)iWebEntity).getUri());
        }
        if (iWebEntity instanceof IWebPath) {
            return this.scopeManager.getActiveScope().filter(((IWebPath)iWebEntity).getUri());
        }
        if (iWebEntity instanceof IWebResponse) {
            IWebPath iWebPath = ((IWebResponse)iWebEntity).getPathEntity();
            return this.scopeManager.getActiveScope().filter(iWebPath.getUri());
        }
        return false;
    }

    private Image getMimeImage(String string) {
        String string2 = this.getMimeImagePath(string);
        if (string2 == null) {
            return null;
        }
        return this.imageCache.get(string2);
    }

    private String getMimeImagePath(String string) {
        if (string == null) {
            return null;
        }
        if (string.matches("text/html.*")) {
            return HTML;
        }
        if (string.matches("text/(javascript|vbscript|tcl)|application/(x-)?(javascript|perl|tcl|c?sh)")) {
            return SCRIPT;
        }
        if (string.matches("((text|application)/xml|application/x-(xhtml|xml)).*")) {
            return XML;
        }
        if (string.matches("text/.*")) {
            return TEXT;
        }
        if (string.matches("image/.*")) {
            return IMAGE;
        }
        if (string.matches("audio/.*")) {
            return AUDIO;
        }
        if (string.matches("video/.*")) {
            return VIDEO;
        }
        if (string.matches("application/x-(archive|arj|.?zip(-compressed)?|compress|cpio|jar|lha|lhz|rar|rpm|deb|stuffit|g?tar|shar).*")) {
            return ARCHIVE;
        }
        if (string.matches("application/java-archive")) {
            return ARCHIVE;
        }
        if (string.matches("application/.*zip.*")) {
            return ARCHIVE;
        }
        if (string.matches("application.*executable.*")) {
            return EXECUTABLE;
        }
        if (string.matches("application/x-shockwave.*")) {
            return FLASH;
        }
        if (string.matches("application/pdf")) {
            return PDF;
        }
        if (string.matches("application/postscript")) {
            return POSTSCRIPT;
        }
        if (string.matches("application/msword")) {
            return MSWORD;
        }
        if (string.matches("application/.*excel")) {
            return SPREADSHEET;
        }
        if (string.matches("application/.*powerpoint")) {
            return PRESENTATION;
        }
        if (string.matches("application/.*font.*")) {
            return FONT;
        }
        if (string.matches("application/(rss|atom)\\+xml.*")) {
            return RSS;
        }
        if (string.matches("application/octet-stream")) {
            return BINARY;
        }
        return null;
    }
}

