/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.web.views;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.NewWebEntityEvent;
import com.subgraph.vega.api.model.web.UpdatedWebEntityEvent;
import com.subgraph.vega.ui.tree.web.WebModelAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class WebsiteContentProvider
implements ITreeContentProvider {
    private final Object[] NULL_OB = new Object[0];
    private IWorkspace workspace;
    private StructuredViewer viewer;
    private final IEventHandler modelListener = this.createModelListener();
    private final List<IWebHost> webHosts = new ArrayList<IWebHost>();
    private final WebModelAdapter treeAdapter = new WebModelAdapter();

    public Object[] getChildren(Object object) {
        return this.treeAdapter.getChildren(object);
    }

    public Object getParent(Object object) {
        return this.treeAdapter.getParent(object);
    }

    public boolean hasChildren(Object object) {
        return this.treeAdapter.hasChildren(object);
    }

    public Object[] getElements(Object object) {
        if (object instanceof IWorkspace) {
            return this.webHosts.toArray(this.NULL_OB);
        }
        return this.treeAdapter.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 == null) {
            this.setNullWorkspace();
        } else if (object2 instanceof IWorkspace) {
            this.setNewWorkspaceAndViewer((IWorkspace)object2, (StructuredViewer)viewer);
        }
    }

    private void setNullWorkspace() {
        this.webHosts.clear();
        this.workspace = null;
    }

    private void setNewWorkspaceAndViewer(IWorkspace iWorkspace, StructuredViewer structuredViewer) {
        if (iWorkspace != this.workspace) {
            if (this.workspace != null) {
                this.workspace.getWebModel().removeChangeListener(this.modelListener);
            }
            this.workspace = iWorkspace;
            this.webHosts.clear();
            this.workspace.getWebModel().addChangeListenerAndPopulate(this.modelListener);
            this.viewer = structuredViewer;
        }
    }

    public void dispose() {
    }

    private IEventHandler createModelListener() {
        return new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof NewWebEntityEvent) {
                    WebsiteContentProvider.this.handleNewWebEntity((NewWebEntityEvent)iEvent);
                } else if (iEvent instanceof UpdatedWebEntityEvent) {
                    WebsiteContentProvider.this.handleUpdatedWebEntity((UpdatedWebEntityEvent)iEvent);
                }
            }
        };
    }

    private void handleNewWebEntity(NewWebEntityEvent newWebEntityEvent) {
        IWebEntity iWebEntity = newWebEntityEvent.getEntity();
        if (iWebEntity instanceof IWebHost) {
            this.webHosts.add((IWebHost)iWebEntity);
        }
        this.refreshViewer();
    }

    private void handleUpdatedWebEntity(UpdatedWebEntityEvent updatedWebEntityEvent) {
        this.refreshElement(updatedWebEntityEvent.getEntity());
    }

    private void refreshElement(final IWebEntity iWebEntity) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                WebsiteContentProvider.this.viewer.refresh((Object)iWebEntity, true);
            }
        });
    }

    private void refreshViewer() {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                WebsiteContentProvider.this.viewer.refresh(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guiRun(Runnable runnable) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            StructuredViewer structuredViewer = this.viewer;
            synchronized (structuredViewer) {
                this.viewer.getControl().getDisplay().asyncExec(runnable);
            }
        }
    }
}

