/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests.config.proxy;

import com.subgraph.vega.internal.http.requests.RequestCopyHeadersInterceptor;
import com.subgraph.vega.internal.http.requests.RequestExtractCookiesInterceptor;
import com.subgraph.vega.internal.http.requests.VegaResponseProcessCookies;
import com.subgraph.vega.internal.http.requests.config.IHttpClientConfigurer;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class ProxyHttpClientConfigurer
implements IHttpClientConfigurer {
    @Override
    public void configureHttpClient(DefaultHttpClient defaultHttpClient) {
        defaultHttpClient.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        this.configureRequestInterceptors(defaultHttpClient);
        this.configureResponseInterceptors(defaultHttpClient);
    }

    private void configureRequestInterceptors(DefaultHttpClient defaultHttpClient) {
        defaultHttpClient.clearRequestInterceptors();
        defaultHttpClient.addRequestInterceptor((HttpRequestInterceptor)new RequestCopyHeadersInterceptor());
        defaultHttpClient.addRequestInterceptor((HttpRequestInterceptor)new RequestExtractCookiesInterceptor());
    }

    private void configureResponseInterceptors(DefaultHttpClient defaultHttpClient) {
        defaultHttpClient.clearResponseInterceptors();
        defaultHttpClient.addResponseInterceptor((HttpResponseInterceptor)new VegaResponseProcessCookies());
    }

    @Override
    public HttpParams createHttpParams() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        return basicHttpParams;
    }
}

