/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests.client;

import com.subgraph.vega.internal.http.requests.client.VegaEntityEnclosingRequestWrapper;
import com.subgraph.vega.internal.http.requests.client.VegaRequestWrapper;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class VegaDecompressingHttpClient
implements HttpClient {
    private HttpClient backend;
    private HttpRequestInterceptor acceptEncodingInterceptor;
    private HttpResponseInterceptor contentEncodingInterceptor;

    public VegaDecompressingHttpClient(HttpClient httpClient) {
        this(httpClient, (HttpRequestInterceptor)new RequestAcceptEncoding(), (HttpResponseInterceptor)new ResponseContentEncoding());
    }

    VegaDecompressingHttpClient(HttpClient httpClient, HttpRequestInterceptor httpRequestInterceptor, HttpResponseInterceptor httpResponseInterceptor) {
        this.backend = httpClient;
        this.acceptEncodingInterceptor = httpRequestInterceptor;
        this.contentEncodingInterceptor = httpResponseInterceptor;
    }

    public HttpParams getParams() {
        return this.backend.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(httpUriRequest), (HttpRequest)httpUriRequest, (HttpContext)null);
    }

    HttpHost getHttpHost(HttpUriRequest httpUriRequest) {
        URI uRI = httpUriRequest.getURI();
        return URIUtils.extractHost((URI)uRI);
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(httpUriRequest), (HttpRequest)httpUriRequest, httpContext);
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException, ClientProtocolException {
        return this.execute(httpHost, httpRequest, (HttpContext)null);
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        try {
            if (httpContext == null) {
                httpContext = new BasicHttpContext();
            }
            AbortableHttpRequest abortableHttpRequest = httpRequest instanceof HttpEntityEnclosingRequest ? new VegaEntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)httpRequest) : new VegaRequestWrapper(httpRequest);
            this.acceptEncodingInterceptor.process((HttpRequest)abortableHttpRequest, httpContext);
            HttpResponse httpResponse = this.backend.execute(httpHost, (HttpRequest)abortableHttpRequest, httpContext);
            this.contentEncodingInterceptor.process(httpResponse, httpContext);
            if (Boolean.TRUE.equals(httpContext.getAttribute("http.client.response.uncompressed"))) {
                httpResponse.removeHeaders("Content-Length");
                httpResponse.removeHeaders("Content-Encoding");
                httpResponse.removeHeaders("Content-MD5");
            }
            return httpResponse;
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException((Throwable)httpException);
        }
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(httpUriRequest), (HttpRequest)httpUriRequest, responseHandler);
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(httpUriRequest), (HttpRequest)httpUriRequest, responseHandler, httpContext);
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(httpHost, httpRequest, responseHandler, null);
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        HttpResponse httpResponse = this.execute(httpHost, httpRequest, httpContext);
        try {
            Object object = responseHandler.handleResponse(httpResponse);
            return (T)object;
        }
        finally {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
    }
}

