/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.http.requests.IHttpRequestEngineConfig;
import com.subgraph.vega.api.http.requests.IHttpResponseProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HttpRequestEngineConfig
implements IHttpRequestEngineConfig {
    private static final int DEFAULT_REQUESTS_PER_MINUTE = 1000;
    private boolean forceIdentityEncoding = false;
    private boolean decompressGzipEncoding = true;
    private boolean undoURLEncoding = false;
    private int requestsPerMinute = 1000;
    private int maxConnections = 25;
    private int maxConnectionsPerRoute = 25;
    private int maximumResponseKilobytes = 0;
    private final List<IHttpResponseProcessor> responseProcessors = new ArrayList<IHttpResponseProcessor>();

    public void setForceIdentityEncoding(boolean bl) {
        this.forceIdentityEncoding = bl;
    }

    public void setDecompressGzipEncoding(boolean bl) {
        this.decompressGzipEncoding = bl;
    }

    public boolean getForceIdentityEncoding() {
        return this.forceIdentityEncoding;
    }

    public boolean getDecompressGzipEncoding() {
        return this.decompressGzipEncoding;
    }

    public void setUndoURLEncoding(boolean bl) {
        this.undoURLEncoding = bl;
    }

    public boolean getUndoURLEncoding() {
        return this.undoURLEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponseProcessor(IHttpResponseProcessor iHttpResponseProcessor) {
        List<IHttpResponseProcessor> list = this.responseProcessors;
        synchronized (list) {
            this.responseProcessors.add(iHttpResponseProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IHttpResponseProcessor> getResponseProcessors() {
        List<IHttpResponseProcessor> list = this.responseProcessors;
        synchronized (list) {
            return Collections.unmodifiableList(this.responseProcessors);
        }
    }

    public void setRequestsPerMinute(int n) {
        this.requestsPerMinute = n;
    }

    public int getRequestsPerMinute() {
        return this.requestsPerMinute;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnectionsPerRoute(int n) {
        this.maxConnectionsPerRoute = n;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaximumResponseKilobytes(int n) {
        this.maximumResponseKilobytes = n;
    }

    public int getMaximumResponseKilobytes() {
        return this.maximumResponseKilobytes;
    }
}

