/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.requests;

import com.subgraph.vega.api.http.requests.IHttpMacroContext;
import com.subgraph.vega.api.http.requests.IHttpMacroExecutor;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.model.macros.IHttpMacro;
import com.subgraph.vega.api.model.macros.IHttpMacroItem;
import com.subgraph.vega.http.requests.builder.HttpRequestBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class HttpMacroExecutor
implements IHttpMacroExecutor {
    private final IHttpRequestEngine requestEngine;
    private final IHttpMacro macro;
    private final Collection<IHttpMacroItem> macroItems;
    private IHttpMacroContext macroContext;
    private Iterator<IHttpMacroItem> macroItemIterator;

    public HttpMacroExecutor(IHttpRequestEngine iHttpRequestEngine, IHttpMacro iHttpMacro, IHttpMacroContext iHttpMacroContext) {
        this.requestEngine = iHttpRequestEngine;
        this.macro = iHttpMacro;
        this.macroItems = iHttpMacro.getMacroItems();
        this.macroContext = iHttpMacroContext;
        this.macroItemIterator = this.macroItems.iterator();
    }

    public IHttpMacro getMacro() {
        return this.macro;
    }

    public IHttpRequestEngine getRequestEngine() {
        return this.requestEngine;
    }

    public IHttpMacroContext getMacroContext() {
        return this.macroContext;
    }

    public boolean hasNext() {
        return this.macroItemIterator.hasNext();
    }

    public IHttpRequestTask sendNextRequest(HttpContext httpContext) throws URISyntaxException, UnsupportedEncodingException {
        if (!this.macroItemIterator.hasNext()) {
            return null;
        }
        IHttpMacroItem iHttpMacroItem = this.macroItemIterator.next();
        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilder();
        iHttpMacroItem.setRequestBuilder((IHttpRequestBuilder)httpRequestBuilder, this.macroContext);
        httpRequestBuilder.removeHeaders("Content-Length");
        httpRequestBuilder.removeHeaders("Content-Type");
        HttpUriRequest httpUriRequest = httpRequestBuilder.buildRequest(false);
        return this.requestEngine.sendRequest(httpUriRequest, httpContext);
    }

    public IHttpRequestTask sendNextRequest() throws URISyntaxException, UnsupportedEncodingException {
        if (!this.macroItemIterator.hasNext()) {
            return null;
        }
        IHttpMacroItem iHttpMacroItem = this.macroItemIterator.next();
        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilder();
        iHttpMacroItem.setRequestBuilder((IHttpRequestBuilder)httpRequestBuilder, this.macroContext);
        httpRequestBuilder.removeHeaders("Content-Length");
        httpRequestBuilder.removeHeaders("Content-Type");
        HttpUriRequest httpUriRequest = httpRequestBuilder.buildRequest(false);
        return this.requestEngine.sendRequest(httpUriRequest);
    }
}

