/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.http.requests.custom;

import com.subgraph.vega.api.util.UriTools;
import com.subgraph.vega.http.requests.custom.IEncodableHttpRequest;
import com.subgraph.vega.internal.http.requests.config.IRequestEncodingStrategy;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.message.BasicRequestLine;

public class VegaHttpUriRequest
extends HttpRequestBase
implements IEncodableHttpRequest {
    private final HttpHost targetHost;
    private final RequestLine requestLine;
    private RequestLine encodedRequestLine;

    public static VegaHttpUriRequest createFrom(HttpHost httpHost, HttpRequest httpRequest) {
        VegaHttpUriRequest vegaHttpUriRequest = new VegaHttpUriRequest(httpHost, httpRequest.getRequestLine());
        vegaHttpUriRequest.setHeaders(httpRequest.getAllHeaders());
        return vegaHttpUriRequest;
    }

    public VegaHttpUriRequest(String string, URI uRI) {
        this(URIUtils.extractHost((URI)uRI), string, VegaHttpUriRequest.uriToRequestUri(uRI));
    }

    private static String uriToRequestUri(URI uRI) {
        StringBuilder stringBuilder = new StringBuilder();
        if (uRI.getPath() != null) {
            stringBuilder.append(uRI.getPath());
        }
        if (uRI.getQuery() != null) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append('?');
            stringBuilder.append(uRI.getQuery());
        }
        return stringBuilder.toString();
    }

    private static RequestLine createRequestLine(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return new BasicRequestLine(string, "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        }
        return new BasicRequestLine(string, string2, (ProtocolVersion)HttpVersion.HTTP_1_1);
    }

    public VegaHttpUriRequest(HttpHost httpHost, String string, String string2) {
        this(httpHost, VegaHttpUriRequest.createRequestLine(string, string2));
    }

    public VegaHttpUriRequest(HttpHost httpHost, RequestLine requestLine) {
        this.targetHost = httpHost;
        this.requestLine = requestLine;
        this.setURI(UriTools.createUriFromTargetAndLine((HttpHost)httpHost, (String)requestLine.getUri()));
    }

    public HttpHost getTargetHost() {
        return this.targetHost;
    }

    public String getScheme() {
        return this.targetHost.getSchemeName();
    }

    public RequestLine getRequestLine() {
        if (this.encodedRequestLine != null) {
            return this.encodedRequestLine;
        }
        return this.requestLine;
    }

    public String getMethod() {
        return this.requestLine.getMethod();
    }

    @Override
    public void encodeWith(IRequestEncodingStrategy iRequestEncodingStrategy) {
        this.encodedRequestLine = iRequestEncodingStrategy.encodeRequestLine(this.requestLine);
    }
}

