/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.http.requests.builder;

import com.subgraph.vega.api.http.requests.IHttpHeaderBuilder;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.http.requests.builder.HttpMessageBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHttpResponse;

public class HttpResponseBuilder
extends HttpMessageBuilder
implements IHttpResponseBuilder {
    private int statusCode = -200;
    private String reasonPhrase = "";

    @Override
    public synchronized void clear() {
        super.clear();
        this.statusCode = 200;
        this.reasonPhrase = "";
    }

    public synchronized void setFromResponse(IRequestLogRecord iRequestLogRecord) {
        this.setFromResponse(iRequestLogRecord.getResponse());
    }

    public synchronized void setFromResponse(HttpResponse httpResponse) {
        this.setFromStatusLine(httpResponse.getStatusLine());
        this.setHeaders(httpResponse.getAllHeaders());
        this.setEntity(httpResponse.getEntity());
    }

    public synchronized void setFromStatusLine(StatusLine statusLine) {
        this.setProtocolVersion(statusLine.getProtocolVersion());
        this.statusCode = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
    }

    public synchronized String getStatusLine() {
        if (this.getProtocolVersion() != null) {
            return String.valueOf(this.getProtocolVersion().toString()) + " " + Integer.toString(this.statusCode) + " " + this.reasonPhrase;
        }
        return "";
    }

    public synchronized HttpResponse buildResponse() {
        IHttpHeaderBuilder[] iHttpHeaderBuilderArray;
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(this.getProtocolVersion(), this.statusCode, this.reasonPhrase);
        this.setHeadersEntity();
        IHttpHeaderBuilder[] iHttpHeaderBuilderArray2 = iHttpHeaderBuilderArray = this.getHeaders();
        int n = iHttpHeaderBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHttpHeaderBuilder iHttpHeaderBuilder = iHttpHeaderBuilderArray2[n2];
            basicHttpResponse.addHeader(iHttpHeaderBuilder.buildHeader());
            ++n2;
        }
        basicHttpResponse.setEntity(this.getEntity());
        return basicHttpResponse;
    }
}

