/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web.forms;

import com.subgraph.vega.api.model.web.IWebPath;
import com.subgraph.vega.api.model.web.forms.IWebForm;
import com.subgraph.vega.internal.model.web.WebModel;
import com.subgraph.vega.internal.model.web.forms.WebForm;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLFormElement;
import org.w3c.dom.html2.HTMLInputElement;

public class FormParser {
    private static final Logger logger = Logger.getLogger("forms");
    private final WebModel model;

    public FormParser(WebModel webModel) {
        this.model = webModel;
    }

    public Collection<IWebForm> parseForms(IWebPath iWebPath, HTMLDocument hTMLDocument) {
        ArrayList<IWebForm> arrayList = new ArrayList<IWebForm>();
        HTMLCollection hTMLCollection = hTMLDocument.getForms();
        int n = 0;
        while (n < hTMLCollection.getLength()) {
            Node node = hTMLCollection.item(n);
            if (node instanceof HTMLFormElement) {
                System.out.println("Processing a form at " + iWebPath);
                WebForm webForm = this.processOneFormElement(iWebPath, (HTMLFormElement)node);
                if (webForm != null) {
                    System.out.println("Adding form with action: " + webForm.getAction());
                    arrayList.add(webForm);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private WebForm processOneFormElement(IWebPath iWebPath, HTMLFormElement hTMLFormElement) {
        URI uRI = this.getFormAction(iWebPath, hTMLFormElement.getAction());
        if (uRI == null) {
            return null;
        }
        WebForm webForm = new WebForm(uRI, this.getFormMethod(hTMLFormElement.getMethod()), this.getEncodingType(hTMLFormElement.getEnctype()));
        HTMLCollection hTMLCollection = hTMLFormElement.getElements();
        int n = 0;
        while (n < hTMLCollection.getLength()) {
            Node node = hTMLCollection.item(n);
            if (node instanceof HTMLInputElement) {
                this.processFormInputField(webForm, (HTMLInputElement)node);
            } else if (node instanceof HTMLElement) {
                this.processFormHTMLElement(webForm, (HTMLElement)node);
            } else {
                logger.warning("Form field not an HTMLElement" + node);
            }
            ++n;
        }
        NodeList nodeList = hTMLFormElement.getElementsByTagName("label");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            if (node instanceof HTMLElement) {
                this.processLabelElement(webForm, (HTMLElement)node);
            }
            ++n2;
        }
        return webForm;
    }

    IWebForm.FormMethod getFormMethod(String string) {
        if (string == null || !string.equalsIgnoreCase("post")) {
            return IWebForm.FormMethod.METHOD_GET;
        }
        return IWebForm.FormMethod.METHOD_POST;
    }

    IWebForm.EncType getEncodingType(String string) {
        if (string == null || !string.equalsIgnoreCase("multipart/form-data")) {
            return IWebForm.EncType.FORM_URLENCODED;
        }
        return IWebForm.EncType.FORM_DATA;
    }

    URI getFormAction(IWebPath iWebPath, String string) {
        if (string == null) {
            return null;
        }
        if (string.contains(":")) {
            URI uRI;
            block7: {
                try {
                    uRI = new URI(string);
                    if (uRI.getScheme() != null && (uRI.getScheme().equals("http") || uRI.getScheme().equals("https"))) break block7;
                    logger.warning("Could not parse form action: " + string);
                    return null;
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.warning("Could not parse form action : " + string);
                    return null;
                }
            }
            return uRI;
        }
        try {
            return iWebPath.getUri().resolve(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.warning("Could not parse form action: " + string);
            return null;
        }
    }

    private void processFormInputField(WebForm webForm, HTMLInputElement hTMLInputElement) {
        String string = hTMLInputElement.getType();
        String string2 = hTMLInputElement.getName();
        String string3 = hTMLInputElement.getValue();
        String string4 = hTMLInputElement.getId();
        if (string == null || string.equalsIgnoreCase("text")) {
            webForm.addTextField(string2, string3, string4, this.searchLabelText((HTMLElement)hTMLInputElement));
        } else if (string.equalsIgnoreCase("password")) {
            webForm.addPasswordField(string2, string3, string4, this.searchLabelText((HTMLElement)hTMLInputElement));
        } else if (string.equalsIgnoreCase("hidden")) {
            webForm.addHiddenField(string2, string4, string3);
        } else if (string.equalsIgnoreCase("checkbox")) {
            webForm.addCheckboxField(string2, string3, string4, hTMLInputElement.getChecked());
        } else if (string.equalsIgnoreCase("radio")) {
            webForm.addCheckboxField(string2, string3, string4, hTMLInputElement.getChecked());
        } else if (string.equalsIgnoreCase("file")) {
            webForm.addFileField(string2);
        }
        String string5 = "<input> name=" + hTMLInputElement.getName() + " type = " + hTMLInputElement.getType() + " value = " + hTMLInputElement.getValue();
        logger.warning(string5);
    }

    private String searchLabelText(HTMLElement hTMLElement) {
        Object object = hTMLElement;
        while (object != null && !(object instanceof HTMLFormElement)) {
            String string;
            Node node = this.getPreviousNonCommentNode((Node)object);
            System.out.println("previousNode: " + node);
            if (node != null && (string = node.getTextContent()) != null && string.length() != 0) {
                return string;
            }
            object = object.getParentNode();
        }
        return null;
    }

    private Node getPreviousNonCommentNode(Node node) {
        Node node2 = node.getPreviousSibling();
        System.out.println("CC previousNode: " + node2);
        while (node2 != null && (node2.getNodeType() == 8 || this.isWhitespaceTextNode(node2))) {
            node2 = node2.getPreviousSibling();
        }
        return node2;
    }

    private boolean isWhitespaceTextNode(Node node) {
        if (!(node instanceof Text)) {
            return false;
        }
        Text text = (Text)node;
        return text.isElementContentWhitespace();
    }

    private void processFormHTMLElement(WebForm webForm, HTMLElement hTMLElement) {
        String string = hTMLElement.getTagName();
        if (string != null && string.equalsIgnoreCase("TEXTAREA")) {
            webForm.addTextArea(hTMLElement.getAttribute("name"), hTMLElement.getAttribute("value"));
        } else {
            logger.warning("Failed to parse HTMLElement in form: " + hTMLElement.getTagName());
        }
    }

    private void processLabelElement(WebForm webForm, HTMLElement hTMLElement) {
        if (hTMLElement.getTagName() == null || !hTMLElement.getTagName().equals("LABEL")) {
            return;
        }
        String string = hTMLElement.getAttribute("id");
        if (string == null) {
            return;
        }
        String string2 = hTMLElement.getTextContent();
        if (string2 == null || string2.trim().isEmpty()) {
            return;
        }
        webForm.addLabelToField(string, string2);
    }
}

