/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web;

import com.db4o.ObjectContainer;
import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebMountPoint;
import com.subgraph.vega.internal.model.web.WebPath;
import org.apache.http.HttpHost;

public class WebMountPoint
implements IWebMountPoint,
Activatable {
    private transient Activator activator;
    private IWebHost host;
    private final WebPath path;

    static WebMountPoint createRootMountPoint(EventListenerManager eventListenerManager, ObjectContainer objectContainer, HttpHost httpHost) {
        WebPath webPath = WebPath.createRootPath(eventListenerManager, objectContainer);
        WebMountPoint webMountPoint = new WebMountPoint(webPath);
        webPath.setMountPoint(webMountPoint);
        return webMountPoint;
    }

    WebMountPoint() {
        this.path = null;
        this.host = null;
    }

    private WebMountPoint(WebPath webPath) {
        this.path = webPath;
        this.host = null;
    }

    WebMountPoint(IWebHost iWebHost, WebPath webPath) {
        this.host = iWebHost;
        this.path = webPath;
    }

    public IWebHost getWebHost() {
        this.activate(ActivationPurpose.READ);
        return this.host;
    }

    public WebPath getMountPath() {
        this.activate(ActivationPurpose.READ);
        return this.path;
    }

    void setWebHost(IWebHost iWebHost) {
        this.activate(ActivationPurpose.READ);
        this.host = iWebHost;
        this.activate(ActivationPurpose.WRITE);
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

