/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web;

import com.db4o.ObjectContainer;
import com.db4o.activation.ActivationPurpose;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.IWebHost;
import com.subgraph.vega.api.model.web.IWebModelVisitor;
import com.subgraph.vega.api.model.web.IWebMountPoint;
import com.subgraph.vega.internal.model.web.WebEntity;
import com.subgraph.vega.internal.model.web.WebMountPoint;
import com.subgraph.vega.internal.model.web.WebPath;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;

public class WebHost
extends WebEntity
implements IWebHost {
    private final HttpHost host;
    private final WebMountPoint mountPoint;
    private final WebPath rootPath;
    private transient URI cachedUri;

    static WebHost createWebHost(EventListenerManager eventListenerManager, ObjectContainer objectContainer, HttpHost httpHost) {
        WebMountPoint webMountPoint = WebMountPoint.createRootMountPoint(eventListenerManager, objectContainer, (HttpHost)Preconditions.checkNotNull((Object)httpHost));
        WebHost webHost = new WebHost(eventListenerManager, objectContainer, httpHost, webMountPoint);
        webMountPoint.setWebHost(webHost);
        return webHost;
    }

    private WebHost(EventListenerManager eventListenerManager, ObjectContainer objectContainer, HttpHost httpHost, WebMountPoint webMountPoint) {
        super(eventListenerManager, objectContainer);
        if (httpHost.getHostName().isEmpty()) {
            throw new IllegalArgumentException("Hostname is empty");
        }
        WebHost.hostToUri(httpHost);
        this.host = httpHost;
        this.mountPoint = webMountPoint;
        this.rootPath = webMountPoint.getMountPath();
    }

    public HttpHost getHttpHost() {
        this.activate(ActivationPurpose.READ);
        return this.host;
    }

    public String getScheme() {
        return this.getHttpHost().getSchemeName();
    }

    public String getHostname() {
        return this.getHttpHost().getHostName();
    }

    public int getPort() {
        return this.getHttpHost().getPort();
    }

    public IWebMountPoint getRootMountPoint() {
        this.activate(ActivationPurpose.READ);
        return this.mountPoint;
    }

    public WebPath getRootPath() {
        this.activate(ActivationPurpose.READ);
        return this.rootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getUri() {
        this.activate(ActivationPurpose.READ);
        WebHost webHost = this;
        synchronized (webHost) {
            if (this.cachedUri == null) {
                this.cachedUri = this.generateUri();
            }
            return this.cachedUri;
        }
    }

    private static URI hostToUri(HttpHost httpHost) {
        try {
            return new URI(httpHost.getSchemeName(), null, httpHost.getHostName(), httpHost.getPort(), null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Unable to convert host to URI: " + httpHost);
        }
    }

    private URI generateUri() {
        return WebHost.hostToUri(this.host);
    }

    public WebPath addPath(String string) {
        this.activate(ActivationPurpose.READ);
        WebPath webPath = this.getRootPath();
        String[] stringArray = string.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (!string2.isEmpty()) {
                webPath = webPath.addChildPath(string2);
            }
            ++n2;
        }
        return webPath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WebHost) {
            WebHost webHost = (WebHost)object;
            return this.getHttpHost().equals((Object)webHost.getHttpHost());
        }
        return false;
    }

    public int hashCode() {
        return this.getHttpHost().hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("host", (Object)this.getHttpHost()).toString();
    }

    public IWebEntity getParent() {
        this.activate(ActivationPurpose.READ);
        return null;
    }

    public void accept(IWebModelVisitor iWebModelVisitor) {
        iWebModelVisitor.visit((IWebHost)this);
        this.getRootPath().accept(iWebModelVisitor);
    }
}

