/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.web;

import com.db4o.ObjectContainer;
import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.model.IModelProperties;
import com.subgraph.vega.api.model.web.IWebEntity;
import com.subgraph.vega.api.model.web.NewWebEntityEvent;
import com.subgraph.vega.api.model.web.UpdatedWebEntityEvent;
import com.subgraph.vega.internal.model.ModelProperties;
import java.util.List;

public abstract class WebEntity
implements IWebEntity,
Activatable {
    private transient Activator activator;
    protected transient EventListenerManager eventManager;
    protected transient ObjectContainer database;
    private boolean visitedFlag;
    private boolean scannedFlag;
    private IModelProperties properties = new ModelProperties();

    protected WebEntity(EventListenerManager eventListenerManager, ObjectContainer objectContainer) {
        this.eventManager = eventListenerManager;
        this.database = objectContainer;
    }

    public boolean isVisited() {
        this.activate(ActivationPurpose.READ);
        return this.visitedFlag;
    }

    public void setVisited(boolean bl) {
        this.activate(ActivationPurpose.READ);
        if (this.getParent() != null) {
            this.getParent().setVisited(bl);
        }
        if (!this.visitedFlag) {
            this.visitedFlag = true;
            this.activate(ActivationPurpose.WRITE);
            if (bl) {
                this.notifyUpdatedEntity(this);
            }
        }
    }

    public boolean isScanned() {
        this.activate(ActivationPurpose.READ);
        return this.scannedFlag;
    }

    public void setScanned() {
        this.activate(ActivationPurpose.READ);
        this.scannedFlag = true;
        this.activate(ActivationPurpose.WRITE);
    }

    public void setProperty(String string, Object object) {
        this.activate(ActivationPurpose.READ);
        this.properties.setProperty(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.activate(ActivationPurpose.READ);
        this.properties.setStringProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.activate(ActivationPurpose.READ);
        this.properties.setIntegerProperty(string, n);
    }

    public Object getProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getProperty(string);
    }

    public String getStringProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getStringProperty(string);
    }

    public Integer getIntegerProperty(String string) {
        this.activate(ActivationPurpose.READ);
        return this.properties.getIntegerProperty(string);
    }

    public List<String> propertyKeys() {
        this.activate(ActivationPurpose.READ);
        return this.properties.propertyKeys();
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }

    void setEventManager(EventListenerManager eventListenerManager) {
        this.eventManager = eventListenerManager;
    }

    void setDatabase(ObjectContainer objectContainer) {
        if (this.database == null) {
            this.database = objectContainer;
        }
    }

    ObjectContainer getDatabase() {
        return this.database;
    }

    void notifyNewEntity(IWebEntity iWebEntity) {
        if (this.eventManager != null) {
            this.eventManager.fireEvent((IEvent)new NewWebEntityEvent(iWebEntity));
        }
    }

    void notifyUpdatedEntity(IWebEntity iWebEntity) {
        if (this.eventManager != null) {
            this.eventManager.fireEvent((IEvent)new UpdatedWebEntityEvent(iWebEntity));
        }
    }
}

