/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.requests;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableArrayList;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.api.model.tags.ITag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class RequestLogRecord
implements IRequestLogRecord,
Activatable {
    final long requestId;
    private final HttpRequest request;
    private IRequestOrigin requestOrigin;
    private final HttpHost host;
    private String hostname;
    private String requestMethod;
    private String requestPath;
    private String requestHeaders;
    private int responseCode;
    private int responseLength;
    private String responseHeaders;
    private HttpResponse response;
    private final long timestamp;
    private long requestTimeMs;
    private ActivatableArrayList<ITag> tagList;
    private transient Activator activator;

    RequestLogRecord(long l, HttpRequest httpRequest, IRequestOrigin iRequestOrigin, HttpResponse httpResponse, HttpHost httpHost, long l2, List<ITag> list) {
        this.requestId = l;
        this.request = httpRequest;
        this.requestOrigin = iRequestOrigin;
        this.response = httpResponse;
        this.host = httpHost;
        this.timestamp = new Date().getTime();
        this.requestTimeMs = l2;
        this.tagList = new ActivatableArrayList(list);
        this.setCachedRequestFields(httpRequest, httpHost);
        this.setCachedResponseFields(httpResponse);
    }

    RequestLogRecord(long l, HttpRequest httpRequest, IRequestOrigin iRequestOrigin, HttpHost httpHost, long l2, List<ITag> list) {
        this(l, httpRequest, iRequestOrigin, null, httpHost, l2, list);
    }

    private void setCachedRequestFields(HttpRequest httpRequest, HttpHost httpHost) {
        if (httpRequest == null) {
            this.hostname = null;
            this.requestMethod = null;
            this.requestHeaders = null;
            this.requestPath = null;
        } else {
            this.hostname = httpHost.getHostName();
            this.requestMethod = httpRequest.getRequestLine().getMethod();
            this.requestHeaders = this.headersToString(httpRequest.getAllHeaders());
            this.requestPath = httpRequest.getRequestLine().getUri();
        }
    }

    private void setCachedResponseFields(HttpResponse httpResponse) {
        if (httpResponse == null) {
            this.responseCode = 0;
            this.responseLength = 0;
            this.responseHeaders = null;
        } else {
            this.responseCode = httpResponse.getStatusLine().getStatusCode();
            this.responseLength = (int)this.getLengthFromResponse(httpResponse);
            this.responseHeaders = this.headersToString(httpResponse.getAllHeaders());
        }
    }

    private String headersToString(Header[] headerArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Header[] headerArray2 = headerArray;
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray2[n2];
            stringBuilder.append(header.getName());
            stringBuilder.append(": ");
            stringBuilder.append(header.getValue());
            stringBuilder.append("\n");
            ++n2;
        }
        return stringBuilder.toString();
    }

    private long getLengthFromResponse(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Content-Length");
        if (header != null) {
            try {
                return Long.parseLong(header.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        if (httpResponse.getEntity() == null) {
            return 0L;
        }
        return httpResponse.getEntity().getContentLength();
    }

    void setResponse(HttpResponse httpResponse) {
        this.activate(ActivationPurpose.READ);
        this.response = httpResponse;
        this.setCachedResponseFields(httpResponse);
        this.activate(ActivationPurpose.WRITE);
    }

    String getHostname() {
        return this.hostname;
    }

    String getRequestMethod() {
        return this.requestMethod;
    }

    String getRequestHeaders() {
        return this.requestHeaders;
    }

    String getRequestPath() {
        return this.requestPath;
    }

    int getResponseCode() {
        return this.responseCode;
    }

    int getResponseLength() {
        return this.responseLength;
    }

    String getResponseHeaders() {
        return this.responseHeaders;
    }

    public long getRequestId() {
        this.activate(ActivationPurpose.READ);
        return this.requestId;
    }

    public long getTimestamp() {
        this.activate(ActivationPurpose.READ);
        return this.timestamp;
    }

    public IRequestOrigin getRequestOrigin() {
        this.activate(ActivationPurpose.READ);
        return this.requestOrigin;
    }

    public long getRequestMilliseconds() {
        this.activate(ActivationPurpose.READ);
        return this.requestTimeMs;
    }

    public HttpRequest getRequest() {
        this.activate(ActivationPurpose.READ);
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse getResponse() {
        this.activate(ActivationPurpose.READ);
        HttpResponse httpResponse = this.response;
        synchronized (httpResponse) {
            return this.response;
        }
    }

    public HttpHost getHttpHost() {
        this.activate(ActivationPurpose.READ);
        return this.host;
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }

    public Collection<ITag> getAllTags() {
        this.activate(ActivationPurpose.READ);
        return Collections.unmodifiableList(new ArrayList<ITag>((Collection<ITag>)this.tagList));
    }

    public ITag getTag(int n) {
        this.activate(ActivationPurpose.READ);
        return (ITag)this.tagList.get(n);
    }

    public int getTagCount() {
        this.activate(ActivationPurpose.READ);
        return this.tagList.size();
    }

    public void setTags(Collection<ITag> collection) {
        this.activate(ActivationPurpose.READ);
        this.tagList.clear();
        this.tagList.addAll(collection);
        this.activate(ActivationPurpose.WRITE);
    }

    public void addTag(ITag iTag) {
        this.activate(ActivationPurpose.READ);
        this.tagList.add((Object)iTag);
        this.activate(ActivationPurpose.WRITE);
    }

    public void removeTag(ITag iTag) {
        this.activate(ActivationPurpose.READ);
        this.tagList.remove((Object)iTag);
        this.activate(ActivationPurpose.WRITE);
    }
}

