/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.requests;

import com.db4o.ObjectContainer;
import com.subgraph.vega.internal.model.requests.RequestLogEntity;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;

public class LazyEntityLoader {
    private final long entityId;
    private final ObjectContainer database;

    LazyEntityLoader(long l, ObjectContainer objectContainer) {
        this.entityId = l;
        this.database = objectContainer;
    }

    HttpEntity getEntity() {
        if (this.entityId == 0L) {
            return null;
        }
        RequestLogEntity requestLogEntity = (RequestLogEntity)this.database.ext().getByID(this.entityId);
        if (requestLogEntity == null) {
            return null;
        }
        this.database.ext().activate((Object)requestLogEntity);
        HttpEntity httpEntity = this.createEntityCopy(requestLogEntity);
        this.database.ext().deactivate((Object)requestLogEntity, 1);
        this.database.ext().purge((Object)requestLogEntity);
        return httpEntity;
    }

    private HttpEntity createEntityCopy(RequestLogEntity requestLogEntity) {
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(requestLogEntity.getContentArray());
        byteArrayEntity.setContentType(requestLogEntity.getContentType());
        byteArrayEntity.setContentEncoding(byteArrayEntity.getContentEncoding());
        return byteArrayEntity;
    }
}

