/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.requests;

import com.db4o.ObjectContainer;
import com.subgraph.vega.internal.model.requests.RequestLogEntity;
import com.subgraph.vega.internal.model.requests.RequestLogEntityEnclosingRequest;
import com.subgraph.vega.internal.model.requests.RequestLogResponse;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.util.EntityUtils;

public class HttpMessageCloner {
    private final ObjectContainer database;

    HttpMessageCloner(ObjectContainer objectContainer) {
        this.database = objectContainer;
    }

    HttpRequest copyRequest(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            return this.copyEntityEnclosingRequest((HttpEntityEnclosingRequest)httpRequest);
        }
        return this.copyBasicRequest(httpRequest);
    }

    HttpResponse copyResponse(HttpResponse httpResponse) {
        HttpEntity httpEntity = this.copyEntity(httpResponse.getEntity());
        RequestLogResponse requestLogResponse = new RequestLogResponse(this.database, httpResponse.getStatusLine(), this.entityToDatabaseId(httpEntity));
        HttpMessageCloner.copyHeaders((HttpMessage)httpResponse, (HttpMessage)requestLogResponse);
        return requestLogResponse;
    }

    private HttpRequest copyEntityEnclosingRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        HttpEntity httpEntity = this.copyEntity(httpEntityEnclosingRequest.getEntity());
        RequestLogEntityEnclosingRequest requestLogEntityEnclosingRequest = new RequestLogEntityEnclosingRequest(this.database, httpEntityEnclosingRequest.getRequestLine(), this.entityToDatabaseId(httpEntity));
        HttpMessageCloner.copyHeaders((HttpMessage)httpEntityEnclosingRequest, (HttpMessage)requestLogEntityEnclosingRequest);
        return requestLogEntityEnclosingRequest;
    }

    private HttpRequest copyBasicRequest(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return null;
        }
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest(httpRequest.getRequestLine());
        HttpMessageCloner.copyHeaders((HttpMessage)httpRequest, (HttpMessage)basicHttpRequest);
        return basicHttpRequest;
    }

    private static void copyHeaders(HttpMessage httpMessage, HttpMessage httpMessage2) {
        Header[] headerArray = httpMessage.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            httpMessage2.addHeader((Header)new BasicHeader(header.getName(), header.getValue()));
            ++n2;
        }
    }

    private long entityToDatabaseId(HttpEntity httpEntity) {
        if (httpEntity == null) {
            return 0L;
        }
        this.database.ext().store((Object)httpEntity);
        return this.database.ext().getID((Object)httpEntity);
    }

    private HttpEntity copyEntity(HttpEntity httpEntity) {
        block3: {
            try {
                if (httpEntity != null) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
        return new RequestLogEntity(byArray, httpEntity.getContentType(), httpEntity.getContentEncoding());
    }
}

