/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.macros;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableArrayList;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.model.macros.IHttpMacro;
import com.subgraph.vega.api.model.macros.IHttpMacroItem;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.internal.model.macros.HttpMacroItem;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;

public class HttpMacro
implements IHttpMacro,
Activatable {
    private transient Activator activator;
    private String name;
    private ActivatableArrayList<IHttpMacroItem> macroItemList = new ActivatableArrayList();

    public void setName(String string) {
        this.activate(ActivationPurpose.READ);
        this.name = string;
        this.activate(ActivationPurpose.WRITE);
    }

    public String getName() {
        this.activate(ActivationPurpose.READ);
        return this.name;
    }

    public IHttpMacroItem createMacroItem(IRequestLogRecord iRequestLogRecord) throws URISyntaxException, IOException {
        this.activate(ActivationPurpose.READ);
        HttpMacroItem httpMacroItem = new HttpMacroItem(iRequestLogRecord);
        this.macroItemList.add((Object)httpMacroItem);
        return httpMacroItem;
    }

    public void removeMacroItem(IHttpMacroItem iHttpMacroItem) {
        this.activate(ActivationPurpose.READ);
        this.macroItemList.remove((Object)iHttpMacroItem);
    }

    public Collection<IHttpMacroItem> getMacroItems() {
        this.activate(ActivationPurpose.READ);
        return new ArrayList<IHttpMacroItem>((Collection<IHttpMacroItem>)this.macroItemList);
    }

    public int macroItemsSize() {
        this.activate(ActivationPurpose.READ);
        return this.macroItemList.size();
    }

    public int indexOfMacroItem(IHttpMacroItem iHttpMacroItem) {
        this.activate(ActivationPurpose.READ);
        return this.macroItemList.indexOf((Object)iHttpMacroItem);
    }

    public void swapMacroItems(int n, int n2) {
        this.activate(ActivationPurpose.READ);
        if (n < this.macroItemList.size() && n2 < this.macroItemList.size() && n != n2) {
            IHttpMacroItem iHttpMacroItem = (IHttpMacroItem)this.macroItemList.set(n, (Object)((IHttpMacroItem)this.macroItemList.get(n2)));
            this.macroItemList.set(n2, (Object)iHttpMacroItem);
        }
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

