/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions.match;

import com.db4o.query.Constraint;
import com.db4o.query.Evaluation;
import com.db4o.query.Query;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionStringMatchAction;
import com.subgraph.vega.internal.model.conditions.match.IHttpConditionMatchActionEx;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class RegexMatchAction
implements IHttpConditionStringMatchAction,
IHttpConditionMatchActionEx {
    private String patternString;
    private transient Pattern pattern;
    private transient boolean patternCompileFailed;
    private transient Evaluation regexConstraint;

    protected RegexMatchAction() {
    }

    protected RegexMatchAction(String string) {
        this.patternString = string;
    }

    protected String getPatternString() {
        return this.patternString;
    }

    public IHttpConditionMatchAction.MatchActionArgumentType getArgumentType() {
        return IHttpConditionMatchAction.MatchActionArgumentType.ARGUMENT_REGEX;
    }

    public String getArgumentAsString() {
        return this.patternString;
    }

    public boolean setArgumentFromString(String string) {
        if (!this.isValidArgumentString(string)) {
            return false;
        }
        this.setString(string);
        return true;
    }

    public boolean isValidArgumentString(String string) {
        return this.createRegexPattern(string) != null;
    }

    protected boolean matchesRegex(String string) {
        Pattern pattern = this.getRegexPattern();
        if (pattern == null || string == null) {
            return false;
        }
        return pattern.matcher(string).find();
    }

    @Override
    public Constraint constrainQuery(Query query) {
        Pattern pattern = this.getRegexPattern();
        if (pattern == null) {
            return null;
        }
        return query.constrain((Object)this.getRegexConstraint(pattern));
    }

    protected abstract Evaluation createQueryEvaluation(Pattern var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Evaluation getRegexConstraint(Pattern pattern) {
        RegexMatchAction regexMatchAction = this;
        synchronized (regexMatchAction) {
            if (this.regexConstraint == null) {
                this.regexConstraint = this.createQueryEvaluation(pattern);
            }
            return this.regexConstraint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern getRegexPattern() {
        if (this.patternCompileFailed) {
            return null;
        }
        RegexMatchAction regexMatchAction = this;
        synchronized (regexMatchAction) {
            if (this.pattern == null && (this.pattern = this.createRegexPattern(this.patternString)) == null) {
                this.patternCompileFailed = true;
            }
            return this.pattern;
        }
    }

    private Pattern createRegexPattern(String string) {
        try {
            return Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public void setString(String string) {
        this.patternString = string;
        this.pattern = null;
        this.patternCompileFailed = false;
        this.regexConstraint = null;
    }
}

