/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableArrayList;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionManager;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.internal.model.conditions.AbstractCondition;
import com.subgraph.vega.internal.model.conditions.HttpConditionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class HttpConditionSet
implements IHttpConditionSet,
Activatable {
    private final String name;
    private final List<IHttpCondition> conditionList = new ActivatableArrayList();
    private boolean matchOnEmptySet;
    private transient Object lock;
    private transient HttpConditionManager conditionManager;
    private transient List<IHttpCondition> temporaryConditions;
    private transient List<IHttpCondition> allConditions;
    private transient Activator activator;

    HttpConditionSet(String string, HttpConditionManager httpConditionManager) {
        this(string, httpConditionManager, null);
    }

    HttpConditionSet(String string, HttpConditionManager httpConditionManager, IHttpConditionSet iHttpConditionSet) {
        this.name = string;
        this.conditionManager = httpConditionManager;
        this.temporaryConditions = new ArrayList<IHttpCondition>();
        this.lock = new Object();
        if (iHttpConditionSet != null) {
            for (IHttpCondition iHttpCondition : iHttpConditionSet.getAllConditions(true)) {
                this.conditionList.add(iHttpCondition.createCopy());
            }
            for (IHttpCondition iHttpCondition : iHttpConditionSet.getAllTemporaryConditions(true)) {
                this.temporaryConditions.add(iHttpCondition.createCopy());
            }
            this.allConditions = new ArrayList<IHttpCondition>();
            this.updateAllConditions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllConditions() {
        Object object = this.lock;
        synchronized (object) {
            if (this.allConditions == null) {
                this.allConditions = new ArrayList<IHttpCondition>();
            } else {
                this.allConditions.clear();
            }
            this.allConditions.addAll(this.conditionList);
            this.allConditions.addAll(this.temporaryConditions);
        }
    }

    private List<IHttpCondition> getAllConditionsList() {
        if (this.allConditions == null) {
            this.allConditions = new ArrayList<IHttpCondition>();
            this.updateAllConditions();
        }
        return this.allConditions;
    }

    public String getName() {
        this.activate(ActivationPurpose.READ);
        return this.name;
    }

    public boolean matchesAll(IRequestLogRecord iRequestLogRecord) {
        this.activate(ActivationPurpose.READ);
        return this.matchesAllConditions(iRequestLogRecord);
    }

    public boolean matchesAll(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.activate(ActivationPurpose.READ);
        return this.matchesAllConditions(httpRequest, httpResponse);
    }

    public boolean matchesAny(IRequestLogRecord iRequestLogRecord) {
        this.activate(ActivationPurpose.READ);
        return this.matchesAnyCondition(iRequestLogRecord);
    }

    public boolean matchesAny(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.activate(ActivationPurpose.READ);
        return this.matchesAnyCondition(httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchesAllConditions(IRequestLogRecord iRequestLogRecord) {
        Object object = this.lock;
        synchronized (object) {
            IHttpCondition iHttpCondition;
            if (this.getAllConditionsList().size() == 0) {
                return this.matchOnEmptySet;
            }
            Iterator<IHttpCondition> iterator = this.getAllConditionsList().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!(iHttpCondition = iterator.next()).isEnabled() || iHttpCondition.matches(iRequestLogRecord));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchesAllConditions(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.activate(ActivationPurpose.READ);
        Object object = this.lock;
        synchronized (object) {
            IHttpCondition iHttpCondition;
            if (this.getAllConditionsList().size() == 0) {
                return this.matchOnEmptySet;
            }
            Iterator<IHttpCondition> iterator = this.getAllConditionsList().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!(iHttpCondition = iterator.next()).isEnabled() || iHttpCondition.matches(httpRequest, httpResponse));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchesAnyCondition(IRequestLogRecord iRequestLogRecord) {
        Object object = this.lock;
        synchronized (object) {
            IHttpCondition iHttpCondition;
            if (this.getAllConditionsList().size() == 0) {
                return this.matchOnEmptySet;
            }
            Iterator<IHttpCondition> iterator = this.getAllConditionsList().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(iHttpCondition = iterator.next()).isEnabled() || !iHttpCondition.matches(iRequestLogRecord));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchesAnyCondition(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.activate(ActivationPurpose.READ);
        Object object = this.lock;
        synchronized (object) {
            IHttpCondition iHttpCondition;
            if (this.getAllConditionsList().size() == 0) {
                return this.matchOnEmptySet;
            }
            Iterator<IHttpCondition> iterator = this.getAllConditionsList().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(iHttpCondition = iterator.next()).isEnabled() || !iHttpCondition.matches(httpRequest, httpResponse));
            return true;
        }
    }

    public void notifyChanged() {
        this.conditionManager.notifyConditionSetChanged(this);
    }

    public boolean hasActiveConditions(boolean bl) {
        return !this.getAllTemporaryConditions(bl).isEmpty() || !this.getAllConditions(bl).isEmpty();
    }

    public void appendCondition(IHttpCondition iHttpCondition, boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.conditionList.add(iHttpCondition);
        this.updateAllConditions();
        if (bl) {
            this.conditionManager.notifyConditionSetChanged(this);
        }
    }

    public void removeCondition(IHttpCondition iHttpCondition, boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.conditionList.remove(iHttpCondition);
        this.updateAllConditions();
        if (bl) {
            this.conditionManager.notifyConditionSetChanged(this);
        }
    }

    public void clearConditions(boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.conditionList.clear();
        this.updateAllConditions();
        if (bl) {
            this.conditionManager.notifyConditionSetChanged(this);
        }
    }

    public List<IHttpCondition> getAllConditions() {
        return this.getAllConditions(false);
    }

    public List<IHttpCondition> getAllConditions(boolean bl) {
        this.activate(ActivationPurpose.READ);
        if (!bl) {
            return Collections.unmodifiableList(new ArrayList<IHttpCondition>(this.conditionList));
        }
        ArrayList<IHttpCondition> arrayList = new ArrayList<IHttpCondition>();
        for (IHttpCondition iHttpCondition : this.conditionList) {
            if (iHttpCondition.isInternal()) continue;
            arrayList.add(iHttpCondition);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void appendTemporaryCondition(IHttpCondition iHttpCondition, boolean bl) {
        this.temporaryConditions.add(iHttpCondition);
        this.updateAllConditions();
        if (bl) {
            this.conditionManager.notifyConditionSetChanged(this);
        }
    }

    public void removeTemporaryCondition(IHttpCondition iHttpCondition, boolean bl) {
        this.temporaryConditions.remove(iHttpCondition);
        this.updateAllConditions();
        if (bl) {
            this.conditionManager.notifyConditionSetChanged(this);
        }
    }

    public void clearTemporaryConditions(boolean bl) {
        this.temporaryConditions.clear();
        this.updateAllConditions();
        if (bl) {
            this.conditionManager.notifyConditionSetChanged(this);
        }
    }

    public List<IHttpCondition> getAllTemporaryConditions(boolean bl) {
        if (!bl) {
            return Collections.unmodifiableList(new ArrayList<IHttpCondition>(this.temporaryConditions));
        }
        ArrayList<IHttpCondition> arrayList = new ArrayList<IHttpCondition>();
        for (IHttpCondition iHttpCondition : this.temporaryConditions) {
            if (iHttpCondition.isInternal()) continue;
            arrayList.add(iHttpCondition);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public IHttpConditionManager getConditionManager() {
        return this.conditionManager;
    }

    void setConditionManager(HttpConditionManager httpConditionManager) {
        this.conditionManager = httpConditionManager;
        this.temporaryConditions = new ArrayList<IHttpCondition>();
        this.lock = new Object();
    }

    public List<IRequestLogRecord> filterRequestLog(ObjectContainer objectContainer) {
        this.activate(ActivationPurpose.READ);
        if (!this.hasRecords(objectContainer)) {
            return Collections.emptyList();
        }
        return this.executeFilterQuery(objectContainer);
    }

    public ObjectSet<IRequestLogRecord> executeFilterQuery(ObjectContainer objectContainer) {
        this.activate(ActivationPurpose.READ);
        Query query = objectContainer.query();
        query.constrain(IRequestLogRecord.class);
        Constraint constraint = null;
        Constraint constraint2 = null;
        for (IHttpCondition iHttpCondition : this.getAllConditionsList()) {
            Constraint constraint3 = ((AbstractCondition)iHttpCondition).filterRequestLogQuery(query);
            if (iHttpCondition.isSufficient()) {
                constraint = this.processConstraintChain(constraint3, constraint, false);
                continue;
            }
            constraint2 = this.processConstraintChain(constraint3, constraint2, true);
        }
        if (constraint != null && constraint2 != null) {
            constraint.or(constraint2);
        }
        if (constraint2 == null) {
            IHttpCondition iHttpCondition;
            iHttpCondition = objectContainer.query();
            iHttpCondition.constrain(IRequestLogRecord.class);
            return iHttpCondition.execute();
        }
        return query.execute();
    }

    private Constraint processConstraintChain(Constraint constraint, Constraint constraint2, boolean bl) {
        if (constraint == null) {
            return constraint2;
        }
        if (constraint2 == null) {
            return constraint;
        }
        if (bl) {
            return constraint2.and(constraint);
        }
        return constraint2.or(constraint);
    }

    private boolean hasRecords(ObjectContainer objectContainer) {
        Query query = objectContainer.query();
        query.constrain(IRequestLogRecord.class);
        return query.execute().hasNext();
    }

    public void setMatchOnEmptySet(boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.matchOnEmptySet = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

