/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model.conditions;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.db4o.ta.Activatable;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionIntegerMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionRangeMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionStringMatchAction;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.internal.model.conditions.match.IHttpConditionMatchActionEx;

public abstract class AbstractCondition
implements IHttpCondition,
Activatable {
    protected IHttpConditionMatchActionEx matchAction;
    private boolean isEnabled;
    private boolean isSufficient;
    private transient Activator activator;

    protected AbstractCondition(IHttpConditionMatchAction iHttpConditionMatchAction) {
        this.matchAction = (IHttpConditionMatchActionEx)iHttpConditionMatchAction;
        this.isEnabled = true;
    }

    public IHttpConditionMatchAction getMatchAction() {
        this.activate(ActivationPurpose.READ);
        return this.matchAction;
    }

    public void setMatchAction(IHttpConditionMatchAction iHttpConditionMatchAction) {
        this.activate(ActivationPurpose.READ);
        if (iHttpConditionMatchAction instanceof IHttpConditionMatchActionEx) {
            this.matchAction = (IHttpConditionMatchActionEx)iHttpConditionMatchAction;
            this.activate(ActivationPurpose.WRITE);
        }
    }

    public boolean matches(IRequestLogRecord iRequestLogRecord) {
        return this.matches(iRequestLogRecord.getRequest(), iRequestLogRecord.getResponse());
    }

    public boolean isEnabled() {
        this.activate(ActivationPurpose.READ);
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.isEnabled = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public IHttpCondition createCopy() {
        this.activate(ActivationPurpose.READ);
        return this.getType().createConditionInstance(this.matchAction.createCopy());
    }

    protected boolean matchesString(String string) {
        this.activate(ActivationPurpose.READ);
        if (this.matchAction instanceof IHttpConditionStringMatchAction) {
            return ((IHttpConditionStringMatchAction)this.matchAction).matchesValue(string);
        }
        throw new IllegalStateException("Expecting an IHttpConditionStringMatchingAction, got" + this.matchAction);
    }

    protected boolean matchesInteger(int n) {
        this.activate(ActivationPurpose.READ);
        if (this.matchAction instanceof IHttpConditionIntegerMatchAction) {
            return ((IHttpConditionIntegerMatchAction)this.matchAction).matchesValue(n);
        }
        if (this.matchAction instanceof IHttpConditionRangeMatchAction) {
            return ((IHttpConditionRangeMatchAction)this.matchAction).matchesValue(n);
        }
        throw new IllegalStateException("Expecting an IHttpConditonIntegerMatchAction or IHttpConditionRangeMatchAction, got" + this.matchAction);
    }

    protected Constraint constrainQuery(Query query) {
        this.activate(ActivationPurpose.READ);
        return this.matchAction.constrainQuery(query);
    }

    public String getValueString() {
        this.activate(ActivationPurpose.READ);
        return this.matchAction.toString();
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isSufficient() {
        this.activate(ActivationPurpose.READ);
        return this.isSufficient;
    }

    public void setSufficient(boolean bl) {
        this.activate(ActivationPurpose.READ);
        this.isSufficient = bl;
        this.activate(ActivationPurpose.WRITE);
    }

    public abstract Constraint filterRequestLogQuery(Query var1);

    public void activate(ActivationPurpose activationPurpose) {
        if (this.activator != null) {
            this.activator.activate(activationPurpose);
        }
    }

    public void bind(Activator activator) {
        if (this.activator == activator) {
            return;
        }
        if (activator != null && this.activator != null) {
            throw new IllegalStateException("Object can only be bound to one activator");
        }
        this.activator = activator;
    }
}

