/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model;

import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.model.WorkspaceLockStatusEvent;

public class WorkspaceLockStatus {
    private final EventListenerManager eventManager;
    private int lockCount = 0;

    WorkspaceLockStatus(EventListenerManager eventListenerManager) {
        this.eventManager = eventListenerManager;
    }

    synchronized void lock() {
        if (this.lockCount == 0) {
            this.eventManager.fireEvent((IEvent)new WorkspaceLockStatusEvent(true));
        }
        ++this.lockCount;
    }

    synchronized void unlock() {
        if (this.lockCount == 0) {
            throw new IllegalStateException("Cannot call unlock() on unlocked workspace.");
        }
        if (this.lockCount == 1) {
            this.eventManager.fireEvent((IEvent)new WorkspaceLockStatusEvent(false));
        }
        --this.lockCount;
    }

    synchronized boolean isLocked() {
        return this.lockCount != 0;
    }
}

