/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model;

import com.subgraph.vega.api.model.IWorkspaceEntry;
import com.subgraph.vega.api.paths.IPathFinder;
import com.subgraph.vega.internal.model.WorkspaceEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class WorkspaceEntries {
    private static final int MAX_WORKSPACE_INDEX = 1000;
    private static final int DEFAULT_WORKSPACE_INDEX = 0;
    private final Logger logger = Logger.getLogger("model");
    private final File workspaceDirectory;
    private final IWorkspaceEntry[] entryArray = new IWorkspaceEntry[1001];

    WorkspaceEntries(IPathFinder iPathFinder) {
        this.workspaceDirectory = iPathFinder.getWorkspaceDirectory();
        this.loadWorkspaceEntries();
    }

    private void loadWorkspaceEntries() {
        if (!this.workspaceDirectory.exists() && !this.workspaceDirectory.mkdirs()) {
            this.logger.warning("Failed to create workspace directory: " + this.workspaceDirectory);
            return;
        }
        if (!this.workspaceDirectory.isDirectory()) {
            this.logger.warning("Workspace directory name exists but is not a directory: " + this.workspaceDirectory);
            return;
        }
        File[] fileArray = this.workspaceDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            WorkspaceEntry workspaceEntry = WorkspaceEntry.createFromPath(file);
            if (workspaceEntry != null) {
                this.entryArray[workspaceEntry.getIndex()] = workspaceEntry;
            }
            ++n2;
        }
        if (this.entryArray[0] == null) {
            this.entryArray[0] = this.createDefaultWorkspace();
        }
    }

    private WorkspaceEntry createDefaultWorkspace() {
        return this.createWorkspace(0, "default");
    }

    /*
     * Loose catch block
     */
    private WorkspaceEntry createWorkspace(int n, String string) {
        File file = this.indexToWorkspacePath(n);
        File file2 = new File(file, ".name");
        if (file.exists()) {
            throw new IllegalStateException("Workspace directory already exists " + file);
        }
        if (!file.mkdirs()) {
            this.logger.warning("Failed to make directory while creating workspace: " + file);
            return null;
        }
        Writer writer = this.openNameFileWriter(file2);
        if (writer == null) {
            return null;
        }
        writer.write(String.valueOf(string) + "\n");
        WorkspaceEntry workspaceEntry = new WorkspaceEntry(string, n, false, file);
        try {
            writer.close();
        }
        catch (IOException iOException) {}
        return workspaceEntry;
        catch (IOException iOException) {
            try {
                this.logger.warning("I/O error writing to name file while creating workspace " + file2);
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    private Writer openNameFileWriter(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            return new OutputStreamWriter(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.warning("Failed to open name file for writing :" + file);
            return null;
        }
    }

    private File indexToWorkspacePath(int n) {
        if (n < 0 || n > 1000) {
            throw new IllegalArgumentException("Workspace index out of range (0 - 1000) : " + n);
        }
        String string = String.format("%02d", n);
        return new File(this.workspaceDirectory, string);
    }

    List<IWorkspaceEntry> getWorkspaceEntries() {
        ArrayList<IWorkspaceEntry> arrayList = new ArrayList<IWorkspaceEntry>();
        int n = 0;
        while (n <= 1000) {
            if (this.entryArray[n] != null) {
                arrayList.add(this.entryArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    IWorkspaceEntry getDefaultWorkspaceEntry() {
        IWorkspaceEntry iWorkspaceEntry = null;
        int n = 0;
        while (n <= 1000) {
            IWorkspaceEntry iWorkspaceEntry2 = this.entryArray[n];
            if (iWorkspaceEntry2 != null) {
                if (iWorkspaceEntry2.isAutostart()) {
                    return iWorkspaceEntry2;
                }
                if (iWorkspaceEntry == null) {
                    iWorkspaceEntry = iWorkspaceEntry2;
                }
            }
            ++n;
        }
        if (iWorkspaceEntry == null) {
            throw new IllegalStateException("No default workspace entry found");
        }
        return iWorkspaceEntry;
    }
}

