/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.ext.DatabaseFileLockedException;
import com.subgraph.vega.api.console.IConsole;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.NamedEventListenerManager;
import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IModelProperties;
import com.subgraph.vega.api.model.IModelVersion;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.IWorkspaceEntry;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.alerts.IScanAlertRepository;
import com.subgraph.vega.api.model.conditions.IHttpConditionManager;
import com.subgraph.vega.api.model.identity.IIdentityModel;
import com.subgraph.vega.api.model.macros.IHttpMacroModel;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.model.scope.ITargetScopeManager;
import com.subgraph.vega.api.model.tags.ITagModel;
import com.subgraph.vega.api.model.variables.IVariableModel;
import com.subgraph.vega.api.model.web.IWebModel;
import com.subgraph.vega.api.xml.IXmlRepository;
import com.subgraph.vega.internal.model.DatabaseConfigurationFactory;
import com.subgraph.vega.internal.model.ModelVersion;
import com.subgraph.vega.internal.model.WorkspaceLockStatus;
import com.subgraph.vega.internal.model.WorkspaceStatus;
import com.subgraph.vega.internal.model.alerts.ScanAlertRepository;
import com.subgraph.vega.internal.model.conditions.HttpConditionManager;
import com.subgraph.vega.internal.model.identity.IdentityModel;
import com.subgraph.vega.internal.model.macros.HttpMacroModel;
import com.subgraph.vega.internal.model.requests.RequestLog;
import com.subgraph.vega.internal.model.scope.TargetScopeManager;
import com.subgraph.vega.internal.model.tags.TagModel;
import com.subgraph.vega.internal.model.variables.VariableModel;
import com.subgraph.vega.internal.model.web.WebModel;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Workspace
implements IWorkspace {
    private static final int BACKGROUND_COMMIT_INTERVAL = 10000;
    private final IModel model;
    private final IWorkspaceEntry workspaceEntry;
    private final NamedEventListenerManager conditionChangeManager;
    private final EventListenerManager eventManager;
    private final DatabaseConfigurationFactory configurationFactory;
    private final IConsole console;
    private final IHTMLParser htmlParser;
    private final IXmlRepository xmlRepository;
    private final WorkspaceLockStatus lockStatus;
    private IModelVersion modelVersion;
    private ITagModel tagModel;
    private IWebModel webModel;
    private IVariableModel variableModel;
    private IHttpMacroModel httpMacroModel;
    private IIdentityModel identityModel;
    private IRequestLog requestLog;
    private IScanAlertRepository scanAlerts;
    private ITargetScopeManager targetScopeManager;
    private HttpConditionManager conditionManager;
    private ObjectContainer database;
    private boolean opened;
    private final Timer backgroundCommitTimer;
    private TimerTask backgroundCommitTask;
    private WorkspaceStatus workspaceStatus;

    Workspace(IModel iModel, IWorkspaceEntry iWorkspaceEntry, NamedEventListenerManager namedEventListenerManager, EventListenerManager eventListenerManager, IConsole iConsole, IHTMLParser iHTMLParser, IXmlRepository iXmlRepository) {
        this.model = iModel;
        this.configurationFactory = new DatabaseConfigurationFactory();
        this.workspaceEntry = iWorkspaceEntry;
        this.conditionChangeManager = namedEventListenerManager;
        this.eventManager = eventListenerManager;
        this.console = iConsole;
        this.htmlParser = iHTMLParser;
        this.xmlRepository = iXmlRepository;
        this.lockStatus = new WorkspaceLockStatus(eventListenerManager);
        this.backgroundCommitTimer = new Timer();
    }

    public IModel getModel() {
        return this.model;
    }

    public boolean open() {
        if (this.opened) {
            throw new IllegalStateException("open() called on workspace which has already been opened.");
        }
        this.database = this.openDatabase(this.getDatabaseFile());
        if (this.database == null) {
            return false;
        }
        this.opened = true;
        this.eventManager.fireEvent((IEvent)new WorkspaceOpenEvent((IWorkspace)this));
        this.backgroundCommitTask = this.createBackgroundCommitTask(this.database);
        this.backgroundCommitTimer.scheduleAtFixedRate(this.backgroundCommitTask, 0L, 10000L);
        return true;
    }

    private File getDatabaseFile() {
        return new File(this.workspaceEntry.getPath(), "model.db");
    }

    private ObjectContainer openDatabase(File file) {
        try {
            String string = file.getAbsolutePath();
            boolean bl = file.exists();
            ObjectContainer objectContainer = this.configurationFactory.openContainer(string);
            this.loadModelVersion(objectContainer, !bl);
            this.tagModel = new TagModel(objectContainer);
            this.webModel = new WebModel(objectContainer);
            this.variableModel = new VariableModel(objectContainer);
            this.httpMacroModel = new HttpMacroModel(objectContainer);
            this.identityModel = new IdentityModel(objectContainer);
            this.requestLog = new RequestLog(objectContainer);
            this.scanAlerts = new ScanAlertRepository(objectContainer, this.xmlRepository);
            this.conditionManager = new HttpConditionManager(objectContainer, this.conditionChangeManager);
            this.targetScopeManager = new TargetScopeManager(objectContainer);
            return objectContainer;
        }
        catch (DatabaseFileLockedException databaseFileLockedException) {
            databaseFileLockedException.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public IModelVersion getModelVersion() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.modelVersion;
    }

    public ITagModel getTagModel() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.tagModel;
    }

    public IVariableModel getVariableModel() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.variableModel;
    }

    public IHttpMacroModel getHttpMacroModel() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.httpMacroModel;
    }

    public IIdentityModel getIdentityModel() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.identityModel;
    }

    public IWebModel getWebModel() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.webModel;
    }

    public IRequestLog getRequestLog() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.requestLog;
    }

    public IScanAlertRepository getScanAlertRepository() {
        if (!this.opened) {
            throw new IllegalStateException("Must open workspace first");
        }
        return this.scanAlerts;
    }

    public IHttpConditionManager getHttpConditionMananger() {
        return this.conditionManager;
    }

    public void close() {
        if (!this.opened) {
            return;
        }
        if (this.lockStatus.isLocked()) {
            throw new IllegalStateException("Cannot close locked workspace.");
        }
        this.backgroundCommitTask.cancel();
        this.conditionManager.notifyClosed();
        this.database.close();
        this.opened = false;
        this.eventManager.fireEvent((IEvent)new WorkspaceCloseEvent((IWorkspace)this));
    }

    public void setProperty(String string, Object object) {
        this.getProperties().setProperty(string, object);
    }

    public void setStringProperty(String string, String string2) {
        this.getProperties().setStringProperty(string, string2);
    }

    public void setIntegerProperty(String string, int n) {
        this.getProperties().setIntegerProperty(string, n);
    }

    public Object getProperty(String string) {
        return this.getProperties().getProperty(string);
    }

    public String getStringProperty(String string) {
        return this.getProperties().getStringProperty(string);
    }

    public Integer getIntegerProperty(String string) {
        return this.getProperties().getIntegerProperty(string);
    }

    public List<String> propertyKeys() {
        return this.getProperties().propertyKeys();
    }

    private IModelProperties getProperties() {
        if (this.workspaceStatus != null) {
            return this.workspaceStatus.getProperties();
        }
        Workspace workspace = this;
        synchronized (workspace) {
            ObjectSet objectSet = this.database.query(WorkspaceStatus.class);
            if (objectSet.size() == 0) {
                this.workspaceStatus = new WorkspaceStatus();
                this.database.store((Object)this.workspaceStatus);
                return this.workspaceStatus.getProperties();
            }
            if (objectSet.size() == 1) {
                this.workspaceStatus = (WorkspaceStatus)objectSet.get(0);
                return this.workspaceStatus.getProperties();
            }
            throw new IllegalStateException("Database corrupted, multiple WorkspaceStatus instances");
        }
    }

    public IHTMLParser getHTMLParser() {
        return this.htmlParser;
    }

    public ITargetScopeManager getTargetScopeManager() {
        return this.targetScopeManager;
    }

    public void consoleWrite(String string) {
        this.console.write(string);
    }

    public void consoleDebug(String string) {
        this.console.debug(string);
    }

    public void consoleError(String string) {
        this.console.error(string);
    }

    public void lock() {
        this.lockStatus.lock();
    }

    public void unlock() {
        this.lockStatus.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.lockStatus.isLocked()) {
            throw new IllegalStateException("Cannot reset locked workspace");
        }
        this.backgroundCommitTask.cancel();
        Workspace workspace = this;
        synchronized (workspace) {
            this.conditionManager.notifyClosed();
            this.database.close();
            File file = this.getDatabaseFile();
            file.delete();
            this.database = this.openDatabase(file);
            if (this.database != null) {
                this.workspaceStatus = null;
                this.eventManager.fireEvent((IEvent)new WorkspaceResetEvent((IWorkspace)this));
                this.backgroundCommitTask = this.createBackgroundCommitTask(this.database);
                this.backgroundCommitTimer.scheduleAtFixedRate(this.backgroundCommitTask, 0L, 10000L);
            } else {
                this.eventManager.fireEvent((IEvent)new WorkspaceCloseEvent((IWorkspace)this));
            }
        }
    }

    private TimerTask createBackgroundCommitTask(final ObjectContainer objectContainer) {
        return new TimerTask(){

            @Override
            public void run() {
                if (!objectContainer.ext().isClosed()) {
                    objectContainer.commit();
                }
            }
        };
    }

    private void loadModelVersion(ObjectContainer objectContainer, boolean bl) {
        if (!bl) {
            ObjectSet objectSet = objectContainer.query(IModelVersion.class);
            if (objectSet.size() != 0) {
                this.modelVersion = (IModelVersion)objectSet.get(0);
            } else {
                this.modelVersion = new ModelVersion(1, 0);
                objectContainer.store((Object)this.modelVersion);
            }
        } else {
            this.modelVersion = new ModelVersion(1, 0);
            objectContainer.store((Object)this.modelVersion);
        }
    }
}

