/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model;

import com.subgraph.vega.api.console.IConsole;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.events.NamedEventListenerManager;
import com.subgraph.vega.api.html.IHTMLParser;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.IWorkspaceEntry;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.paths.IPathFinder;
import com.subgraph.vega.api.xml.IXmlRepository;
import com.subgraph.vega.internal.model.Workspace;
import com.subgraph.vega.internal.model.WorkspaceEntries;
import java.util.List;
import java.util.logging.Logger;

public class Model
implements IModel {
    private final Logger logger = Logger.getLogger("model");
    private final EventListenerManager workspaceEventManager = new EventListenerManager();
    private final NamedEventListenerManager conditionSetChangeEventManager = new NamedEventListenerManager();
    private IWorkspace currentWorkspace;
    private IConsole console;
    private IHTMLParser htmlParser;
    private IXmlRepository xmlRepository;
    private IPathFinder pathFinder;
    private WorkspaceEntries workspaceEntries;

    public void activate() {
        this.workspaceEntries = new WorkspaceEntries(this.pathFinder);
    }

    protected void setConsole(IConsole iConsole) {
        this.console = iConsole;
    }

    protected void unsetConsole(IConsole iConsole) {
        this.console = null;
    }

    protected void setHTMLParser(IHTMLParser iHTMLParser) {
        this.htmlParser = iHTMLParser;
    }

    protected void unsetHTMLParser(IHTMLParser iHTMLParser) {
        this.htmlParser = null;
    }

    protected void setXmlRepository(IXmlRepository iXmlRepository) {
        this.xmlRepository = iXmlRepository;
    }

    protected void unsetXmlRepository(IXmlRepository iXmlRepository) {
        this.xmlRepository = null;
    }

    protected void setPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = iPathFinder;
    }

    protected void unsetPathFinder(IPathFinder iPathFinder) {
        this.pathFinder = null;
    }

    public IWorkspace addWorkspaceListener(IEventHandler iEventHandler) {
        this.workspaceEventManager.addListener(iEventHandler);
        return this.currentWorkspace;
    }

    public void removeWorkspaceListener(IEventHandler iEventHandler) {
        this.workspaceEventManager.removeListener(iEventHandler);
    }

    public List<IWorkspaceEntry> getWorkspaceEntries() {
        return this.workspaceEntries.getWorkspaceEntries();
    }

    public boolean openDefaultWorkspace() {
        IWorkspaceEntry iWorkspaceEntry = this.workspaceEntries.getDefaultWorkspaceEntry();
        if (iWorkspaceEntry == null) {
            return false;
        }
        return this.openWorkspaceEntry(iWorkspaceEntry);
    }

    public boolean openWorkspaceByIndex(int n) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private boolean openWorkspaceEntry(IWorkspaceEntry iWorkspaceEntry) {
        Workspace workspace = new Workspace(this, iWorkspaceEntry, this.conditionSetChangeEventManager, this.workspaceEventManager, this.console, this.htmlParser, this.xmlRepository);
        if (!workspace.open()) {
            this.logger.warning("Failed to open workspace at path " + iWorkspaceEntry.getPath());
            return false;
        }
        this.currentWorkspace = workspace;
        return true;
    }

    public void resetCurrentWorkspace() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.reset();
        }
    }

    public IWorkspace getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public IHttpConditionSet addConditionSetTracker(String string, IEventHandler iEventHandler) {
        this.conditionSetChangeEventManager.addListener(string, iEventHandler);
        if (this.currentWorkspace != null) {
            return this.currentWorkspace.getHttpConditionMananger().getConditionSet(string);
        }
        return null;
    }

    public void removeConditionSetTracker(String string, IEventHandler iEventHandler) {
        this.conditionSetChangeEventManager.removeListener(string, iEventHandler);
    }
}

