/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.model;

import com.db4o.Db4oEmbedded;
import com.db4o.ObjectContainer;
import com.db4o.config.ConfigurationItem;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.jdk.JdkReflector;
import com.db4o.ta.TransparentPersistenceSupport;
import com.subgraph.vega.internal.model.alerts.ScanAlert;
import com.subgraph.vega.internal.model.requests.RequestLogRecord;
import com.subgraph.vega.internal.model.tags.Tag;

public class DatabaseConfigurationFactory {
    private static final boolean LAZY_EVALUATION = true;
    private static final boolean DIAGNOSTICS_ENABLED = false;
    private static final boolean DEBUG_OUTPUT_ENABLED = false;
    private static final int DEBUG_OUTPUT_LEVEL = 4;

    public EmbeddedConfiguration createDefaultConfiguration() {
        EmbeddedConfiguration embeddedConfiguration = Db4oEmbedded.newConfiguration();
        embeddedConfiguration.common().reflectWith((Reflector)new JdkReflector(this.getClass().getClassLoader()));
        embeddedConfiguration.common().add((ConfigurationItem)new TransparentPersistenceSupport());
        embeddedConfiguration.common().objectClass(RequestLogRecord.class).objectField("requestId").indexed(true);
        embeddedConfiguration.common().objectClass(RequestLogRecord.class).objectField("requestOrigin").indexed(true);
        embeddedConfiguration.common().objectClass(RequestLogRecord.class).objectField("hostname").indexed(true);
        embeddedConfiguration.common().objectClass(RequestLogRecord.class).objectField("requestMethod").indexed(true);
        embeddedConfiguration.common().objectClass(RequestLogRecord.class).objectField("responseCode").indexed(true);
        embeddedConfiguration.common().objectClass(RequestLogRecord.class).objectField("responseLength").indexed(true);
        embeddedConfiguration.common().objectClass(RequestLogRecord.class).objectField("tagList").indexed(true);
        embeddedConfiguration.common().objectClass(ScanAlert.class).objectField("key").indexed(true);
        embeddedConfiguration.common().objectClass(ScanAlert.class).objectField("resource").indexed(true);
        embeddedConfiguration.common().objectClass(ScanAlert.class).objectField("requestId").indexed(true);
        embeddedConfiguration.common().objectClass(Tag.class).objectField("name").indexed(true);
        embeddedConfiguration.common().weakReferences(true);
        embeddedConfiguration.common().queries().evaluationMode(QueryEvaluationMode.LAZY);
        return embeddedConfiguration;
    }

    public ObjectContainer openContainer(String string) {
        EmbeddedConfiguration embeddedConfiguration = this.createDefaultConfiguration();
        return Db4oEmbedded.openFile((EmbeddedConfiguration)embeddedConfiguration, (String)string);
    }

    public ObjectContainer openContainer(EmbeddedConfiguration embeddedConfiguration, String string) {
        return Db4oEmbedded.openFile((EmbeddedConfiguration)embeddedConfiguration, (String)string);
    }
}

