/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.crawler;

import com.subgraph.vega.api.crawler.IWebCrawler;
import com.subgraph.vega.api.crawler.IWebCrawlerFactory;
import com.subgraph.vega.api.http.requests.IHttpRequestEngine;
import com.subgraph.vega.api.http.requests.IHttpRequestEngineFactory;
import com.subgraph.vega.api.model.requests.IRequestOrigin;
import com.subgraph.vega.internal.crawler.WebCrawler;

public class WebCrawlerFactory
implements IWebCrawlerFactory {
    private static final int DEFAULT_RESPONSE_THREAD_COUNT = 20;
    private static final int MIN_REQUEST_THREAD_COUNT = 5;
    private static final int MAX_REQUEST_THREAD_COUNT = 100;
    private IHttpRequestEngineFactory requestEngineFactory;

    public IWebCrawler create(IRequestOrigin iRequestOrigin) {
        IHttpRequestEngine iHttpRequestEngine = this.requestEngineFactory.createRequestEngine(IHttpRequestEngine.EngineConfigType.CONFIG_SCANNER, this.requestEngineFactory.createConfig(), iRequestOrigin);
        return this.create(iHttpRequestEngine);
    }

    public IWebCrawler create(IHttpRequestEngine iHttpRequestEngine) {
        return new WebCrawler(iHttpRequestEngine, this.getRequestThreadCount(iHttpRequestEngine), 20);
    }

    protected void setRequestEngineFactory(IHttpRequestEngineFactory iHttpRequestEngineFactory) {
        this.requestEngineFactory = iHttpRequestEngineFactory;
    }

    protected void unsetRequestEngineFactory(IHttpRequestEngineFactory iHttpRequestEngineFactory) {
        this.requestEngineFactory = null;
    }

    private int getRequestThreadCount(IHttpRequestEngine iHttpRequestEngine) {
        int n = iHttpRequestEngine.getRequestEngineConfig().getMaxConnections();
        if (n < 5) {
            return 5;
        }
        if (n > 100) {
            return 100;
        }
        return n;
    }
}

