/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.util.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class VegaPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private ArrayList<FieldEditor> fieldList = new ArrayList();

    protected VegaPreferencePage() {
        this("");
    }

    protected VegaPreferencePage(String string) {
        super(string);
    }

    protected VegaPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Control createContents(Composite composite) {
        Control control = this.createPage(composite);
        for (FieldEditor fieldEditor : this.fieldList) {
            fieldEditor.setPage((DialogPage)this);
            fieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
            fieldEditor.setPreferenceStore(this.getPreferenceStore());
            fieldEditor.load();
        }
        this.checkState();
        return control;
    }

    protected abstract Control createPage(Composite var1);

    protected void performDefaults() {
        super.performDefaults();
        Iterator<FieldEditor> iterator = this.fieldList.iterator();
        while (iterator.hasNext()) {
            iterator.next().loadDefault();
        }
        this.checkState();
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        if (bl) {
            Iterator<FieldEditor> iterator = this.fieldList.iterator();
            while (iterator.hasNext()) {
                iterator.next().store();
            }
        }
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.checkState();
            } else {
                this.setValid(false);
            }
        }
    }

    protected void addField(FieldEditor fieldEditor) {
        this.fieldList.add(fieldEditor);
    }

    private void checkState() {
        Iterator<FieldEditor> iterator = this.fieldList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isValid()) continue;
            this.setValid(false);
            return;
        }
        this.setValid(true);
    }
}

