/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.macros.macrosview;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.macros.IHttpMacroModel;
import com.subgraph.vega.ui.macros.Activator;
import com.subgraph.vega.ui.macros.macrosview.tree.MacroViewerContentProvider;
import com.subgraph.vega.ui.macros.macrosview.tree.MacroViewerLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class MacrosView
extends ViewPart {
    public static final String ID = "com.subgraph.vega.views.macros.macros";
    private IHttpMacroModel macroModel;
    private Composite parentComposite;
    private TreeViewer macroViewer;

    public MacrosView() {
        IWorkspace iWorkspace = Activator.getDefault().getModel().addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    MacrosView.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    MacrosView.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    MacrosView.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        });
        this.macroModel = iWorkspace.getHttpMacroModel();
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.macroModel = workspaceOpenEvent.getWorkspace().getHttpMacroModel();
        this.macroViewer.setInput((Object)this.macroModel);
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.macroModel = null;
        this.macroViewer.setInput((Object)this.macroModel);
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.macroModel = workspaceResetEvent.getWorkspace().getHttpMacroModel();
        this.macroViewer.setInput((Object)this.macroModel);
    }

    public void createPartControl(Composite composite) {
        this.parentComposite = new Composite(composite, 0);
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.createTreeViewer(this.parentComposite);
        this.macroViewer.setInput((Object)this.macroModel);
    }

    public void setFocus() {
        this.parentComposite.setFocus();
    }

    private void createTreeViewer(Composite composite) {
        this.macroViewer = new TreeViewer(composite, 770);
        this.macroViewer.setContentProvider((IContentProvider)new MacroViewerContentProvider());
        this.macroViewer.setLabelProvider((IBaseLabelProvider)new MacroViewerLabelProvider());
    }
}

