/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.macros.macrodialog;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceOpenEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.api.model.macros.IHttpMacro;
import com.subgraph.vega.api.model.macros.IHttpMacroItem;
import com.subgraph.vega.api.model.macros.IHttpMacroModel;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.internal.ui.macros.macrodialog.MacroItemEditor;
import com.subgraph.vega.internal.ui.macros.macrodialog.MacroItemSelectionDialog;
import com.subgraph.vega.internal.ui.macros.macrodialog.MacroItemTableContentProvider;
import com.subgraph.vega.ui.http.builder.HeaderEditor;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import com.subgraph.vega.ui.http.builder.RequestEditor;
import com.subgraph.vega.ui.macros.Activator;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MacroDialog
extends TitleAreaDialog {
    private IHttpMacroModel macroModel;
    private IHttpMacro macro;
    private IHttpRequestBuilder requestBuilder;
    private Composite parentComposite;
    private Text macroNameText;
    private TableViewer macroItemTableViewer;
    private Button addItemButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button removeButton;
    private TabFolder macroItemTabFolder;
    private TabItem macroItemTabFolderItem;
    private MacroItemEditor macroItemEditor;
    private IHttpBuilderPart requestBuilderPartCurr;
    private boolean requestIsEditable;

    public static MacroDialog createDialog(Shell shell) {
        return MacroDialog.createDialog(shell, null);
    }

    public static MacroDialog createDialog(Shell shell, IHttpMacro iHttpMacro) {
        MacroDialog macroDialog = new MacroDialog(shell, iHttpMacro);
        macroDialog.create();
        macroDialog.getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        return macroDialog;
    }

    private MacroDialog(Shell shell, IHttpMacro iHttpMacro) {
        super(shell);
        IWorkspace iWorkspace = Activator.getDefault().getModel().addWorkspaceListener(new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceOpenEvent) {
                    MacroDialog.this.handleWorkspaceOpen((WorkspaceOpenEvent)iEvent);
                } else if (iEvent instanceof WorkspaceCloseEvent) {
                    MacroDialog.this.handleWorkspaceClose((WorkspaceCloseEvent)iEvent);
                } else if (iEvent instanceof WorkspaceResetEvent) {
                    MacroDialog.this.handleWorkspaceReset((WorkspaceResetEvent)iEvent);
                }
            }
        });
        this.macroModel = iWorkspace.getHttpMacroModel();
        this.macro = iHttpMacro != null ? iHttpMacro : this.macroModel.createMacro();
        this.requestBuilder = Activator.getDefault().getHttpRequestEngineFactoryService().createRequestBuilder();
    }

    private void handleWorkspaceOpen(WorkspaceOpenEvent workspaceOpenEvent) {
        this.macroModel = workspaceOpenEvent.getWorkspace().getHttpMacroModel();
    }

    private void handleWorkspaceClose(WorkspaceCloseEvent workspaceCloseEvent) {
        this.macroModel = null;
    }

    private void handleWorkspaceReset(WorkspaceResetEvent workspaceResetEvent) {
        this.macroModel = workspaceResetEvent.getWorkspace().getHttpMacroModel();
    }

    public IHttpMacro getMacro() {
        return this.macro;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        String string = this.macroNameText.getText().trim();
        if (string.isEmpty()) {
            this.setErrorMessage("The macro name cannot be empty");
            return;
        }
        IHttpMacro iHttpMacro = this.macroModel.getMacroByName(string);
        if (iHttpMacro != null && iHttpMacro != this.macro) {
            this.setErrorMessage("A macro by that name already exists");
            return;
        }
        this.setErrorMessage(null);
        this.macro.setName(string);
        this.macroModel.store(this.macro);
        super.okPressed();
    }

    public void create() {
        super.create();
        this.setTitle("Macro Editor");
        this.setMessage("Select items for the macro, then modify their characteristics");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.parentComposite = new Composite(composite2, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.parentComposite.setLayoutData((Object)new GridData(1808));
        this.createMacroArea(this.parentComposite).setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.createItemsArea(this.parentComposite).setLayoutData((Object)new GridData(1808));
        this.createItemEditor(this.parentComposite).setLayoutData((Object)new GridData(1808));
        this.macroItemTableViewer.setInput((Object)this.macro);
        return composite2;
    }

    private Composite createMacroArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Macro");
        Label label = new Label((Composite)group, 0);
        label.setText("Macro Name:");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.macroNameText = new Text((Composite)group, 2052);
        this.macroNameText.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        FontMetrics fontMetrics = new GC((Drawable)this.macroNameText).getFontMetrics();
        GridData gridData = new GridData(4, 4, false, false, 1, 1);
        gridData.widthHint = fontMetrics.getAverageCharWidth() * 50;
        this.macroNameText.setLayoutData((Object)gridData);
        return group;
    }

    private Composite createItemsArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Macro Items");
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.createItemsTable((Composite)group, gridData, 8).setLayoutData((Object)gridData);
        this.createItemsButtons((Composite)group).setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        return group;
    }

    private Composite createItemsTable(Composite composite, GridData gridData, int n) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.macroItemTableViewer = new TableViewer(composite2, 68354);
        this.macroItemTableViewer.setContentProvider((IContentProvider)new MacroItemTableContentProvider());
        this.macroItemTableViewer.addSelectionChangedListener(this.createMacroItemTableSelectionChangedListener());
        this.createItemsTableColumns(this.macroItemTableViewer, tableColumnLayout);
        Table table = this.macroItemTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData.heightHint = table.getItemHeight() * n;
        return composite2;
    }

    private ISelectionChangedListener createMacroItemTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                boolean bl = !selectionChangedEvent.getSelection().isEmpty();
                MacroDialog.this.moveUpButton.setEnabled(bl);
                MacroDialog.this.moveDownButton.setEnabled(bl);
                MacroDialog.this.removeButton.setEnabled(bl);
                if (bl) {
                    IHttpMacroItem iHttpMacroItem = (IHttpMacroItem)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                    MacroDialog.this.setMacroItemSelected(iHttpMacroItem);
                } else {
                    MacroDialog.this.setMacroItemSelected(null);
                }
            }
        };
    }

    private void createItemsTableColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"Host", "Method", "Request", "Status"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(120, true, true), new ColumnPixelData(60, true, true), new ColumnWeightData(100, 500, true), new ColumnPixelData(50, true, true)};
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpMacroItem)object).getRequestLogRecord().getHttpHost().toURI();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpMacroItem)object).getRequestLogRecord().getRequest().getRequestLine().getMethod();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                URI uRI;
                try {
                    uRI = new URI(((IHttpMacroItem)object).getRequestLogRecord().getRequest().getRequestLine().getUri());
                }
                catch (URISyntaxException uRISyntaxException) {
                    return null;
                }
                if (uRI.getRawQuery() != null) {
                    return String.valueOf(uRI.getRawPath()) + "?" + uRI.getRawQuery();
                }
                return uRI.getRawPath();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return Integer.valueOf(((IHttpMacroItem)object).getRequestLogRecord().getResponse().getStatusLine().getStatusCode()).toString();
            }
        }};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private Composite createItemsButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.addItemButton = new Button(composite2, 8);
        this.addItemButton.setText("add item");
        this.addItemButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addItemButton.addSelectionListener(this.createAddItemButtonSelectionListener());
        this.moveUpButton = new Button(composite2, 8);
        this.moveUpButton.setText("move up");
        this.moveUpButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addSelectionListener(this.createMoveUpButtonSelectionListener());
        this.moveDownButton = new Button(composite2, 8);
        this.moveDownButton.setText("move down");
        this.moveDownButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addSelectionListener(this.createMoveDownButtonSelectionListener());
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText("remove");
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener(this.createRemoveButtonSelectionListener());
        return composite2;
    }

    private SelectionListener createAddItemButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MacroItemSelectionDialog macroItemSelectionDialog = new MacroItemSelectionDialog(MacroDialog.this.parentComposite.getShell());
                if (macroItemSelectionDialog.open() == 0) {
                    List<IRequestLogRecord> list = macroItemSelectionDialog.getSelectionList();
                    Iterator<IRequestLogRecord> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        try {
                            MacroDialog.this.macro.createMacroItem(iterator.next());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            ErrorDialog.displayError((Shell)MacroDialog.this.getShell(), (String)"An unexpected error occurred while processing the URI");
                            uRISyntaxException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            ErrorDialog.displayError((Shell)MacroDialog.this.getShell(), null);
                            iOException.printStackTrace();
                        }
                    }
                    MacroDialog.this.macroItemTableViewer.refresh();
                }
            }
        };
    }

    private SelectionListener createMoveUpButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MacroDialog.this.macroItemTableViewer.getSelection();
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    int n = MacroDialog.this.macro.indexOfMacroItem((IHttpMacroItem)iterator.next());
                    if (n == 0) break;
                    MacroDialog.this.macro.swapMacroItems(n - 1, n);
                }
                MacroDialog.this.macroItemTableViewer.refresh();
            }
        };
    }

    private SelectionListener createMoveDownButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MacroDialog.this.macroItemTableViewer.getSelection();
                int[] nArray = new int[iStructuredSelection.size()];
                int n = 1;
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    nArray[nArray.length - n] = MacroDialog.this.macro.indexOfMacroItem((IHttpMacroItem)iterator.next());
                    ++n;
                }
                if (nArray[0] + 1 != MacroDialog.this.macro.macroItemsSize()) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        MacroDialog.this.macro.swapMacroItems(nArray[n2], nArray[n2] + 1);
                        ++n2;
                    }
                }
                MacroDialog.this.macroItemTableViewer.refresh();
            }
        };
    }

    private SelectionListener createRemoveButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)MacroDialog.this.macroItemTableViewer.getSelection();
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    MacroDialog.this.macro.removeMacroItem((IHttpMacroItem)iterator.next());
                }
                MacroDialog.this.macroItemTableViewer.refresh();
            }
        };
    }

    private Composite createItemEditor(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        this.macroItemTabFolder = new TabFolder(composite2, 128);
        TabItem tabItem = new TabItem(this.macroItemTabFolder, 0);
        tabItem.setText("Params");
        this.macroItemEditor = new MacroItemEditor((Composite)this.macroItemTabFolder, this.requestBuilder);
        tabItem.setControl((Control)this.macroItemEditor);
        tabItem.setData((Object)this.macroItemEditor);
        TabItem tabItem2 = new TabItem(this.macroItemTabFolder, 0);
        tabItem2.setText("Request");
        RequestEditor requestEditor = new RequestEditor((Composite)this.macroItemTabFolder, this.requestBuilder);
        tabItem2.setControl((Control)requestEditor);
        tabItem2.setData((Object)requestEditor);
        TabItem tabItem3 = new TabItem(this.macroItemTabFolder, 0);
        tabItem3.setText("Headers");
        HeaderEditor headerEditor = new HeaderEditor((Composite)this.macroItemTabFolder, (IHttpMessageBuilder)this.requestBuilder, 0);
        tabItem3.setControl((Control)headerEditor);
        tabItem3.setData((Object)headerEditor);
        this.macroItemTabFolder.addSelectionListener(this.createRequestTabFolderSelectionListener());
        this.macroItemTabFolderItem = this.macroItemTabFolder.getSelection()[0];
        this.requestBuilderPartCurr = (IHttpBuilderPart)this.macroItemTabFolderItem.getData();
        this.requestIsEditable = false;
        this.requestBuilderPartCurr.setEditable(this.requestIsEditable);
        return composite2;
    }

    private SelectionListener createRequestTabFolderSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabItem[] tabItemArray = MacroDialog.this.macroItemTabFolder.getSelection();
                if (tabItemArray != null) {
                    try {
                        MacroDialog.this.requestBuilderPartCurr.processContents();
                    }
                    catch (Exception exception) {
                        MacroDialog.this.macroItemTabFolder.setSelection(MacroDialog.this.macroItemTabFolderItem);
                        ErrorDialog.displayError((Shell)MacroDialog.this.getShell(), (String)"An unexpected error occurred processing the request");
                        exception.printStackTrace();
                        return;
                    }
                }
                MacroDialog.this.macroItemTabFolderItem = tabItemArray[0];
                MacroDialog.this.requestBuilderPartCurr = (IHttpBuilderPart)MacroDialog.this.macroItemTabFolderItem.getData();
                MacroDialog.this.requestBuilderPartCurr.setEditable(MacroDialog.this.requestIsEditable);
                MacroDialog.this.requestBuilderPartCurr.refresh();
            }
        };
    }

    private void setMacroItemSelected(IHttpMacroItem iHttpMacroItem) {
        if (iHttpMacroItem != null) {
            try {
                iHttpMacroItem.setRequestBuilder(this.requestBuilder, null);
            }
            catch (Exception exception) {
                ErrorDialog.displayError((Shell)this.getShell(), (String)"An unexpected error occurred while processing the request");
                exception.printStackTrace();
                return;
            }
            this.requestIsEditable = true;
        } else {
            this.requestBuilder.clear();
            this.requestIsEditable = false;
        }
        this.macroItemEditor.setMacroItem(iHttpMacroItem);
        this.requestBuilderPartCurr.setEditable(this.requestIsEditable);
        this.requestBuilderPartCurr.refresh();
    }
}

