/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageCache {
    private final String pluginId;
    private final Map<ImageDescriptor, Image> imageMap = new HashMap<ImageDescriptor, Image>();
    private final Map<String, Image> disabledMap = new HashMap<String, Image>();

    public ImageCache(String string) {
        this.pluginId = string;
    }

    public Image get(String string) {
        return this.get(this.getDescriptor(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getDisabled(String string) {
        Map<String, Image> map = this.disabledMap;
        synchronized (map) {
            Image image = this.disabledMap.get(string);
            if (image == null) {
                return this.getDisabledImageAndCache(string);
            }
            return image;
        }
    }

    private Image getDisabledImageAndCache(String string) {
        Image image = this.get(string);
        if (image == null) {
            return null;
        }
        Image image2 = new Image(image.getDevice(), image, 2);
        this.disabledMap.put(string, image2);
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image get(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Map<ImageDescriptor, Image> map = this.imageMap;
        synchronized (map) {
            Image image = this.imageMap.get(imageDescriptor);
            if (image == null) {
                return this.getImageAndCache(imageDescriptor);
            }
            return image;
        }
    }

    private ImageDescriptor getDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.pluginId, (String)string);
    }

    private Image getImageAndCache(ImageDescriptor imageDescriptor) {
        Image image = imageDescriptor.createImage();
        this.imageMap.put(imageDescriptor, image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<Object, Image> map = this.imageMap;
        synchronized (map) {
            for (Image image : this.imageMap.values()) {
                image.dispose();
            }
        }
        this.imageMap.clear();
        map = this.disabledMap;
        synchronized (map) {
            for (Image image : this.disabledMap.values()) {
                image.dispose();
            }
        }
        this.disabledMap.clear();
    }
}

