/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.console;

import com.subgraph.vega.api.console.ConsoleOutputEvent;
import com.subgraph.vega.api.console.IConsole;
import com.subgraph.vega.api.console.IConsoleDisplay;
import com.subgraph.vega.api.events.EventListenerManager;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import java.util.ArrayList;
import java.util.List;

public class ConsoleService
implements IConsole {
    private static final int MAX_BUFFER = 8192;
    private final List<IConsoleDisplay> displays = new ArrayList<IConsoleDisplay>();
    private final EventListenerManager eventManager = new EventListenerManager();
    private StringBuilder outputBuffer = null;
    private StringBuilder errorBuffer = null;

    public synchronized void write(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (!string.endsWith("\n")) {
            string = String.valueOf(string) + "\n";
        }
        if (this.displays.size() == 0) {
            this.bufferOutput(string);
        } else {
            for (IConsoleDisplay iConsoleDisplay : this.displays) {
                iConsoleDisplay.printOutput(string);
            }
            this.eventManager.fireEvent((IEvent)new ConsoleOutputEvent(string, false));
        }
    }

    public synchronized void debug(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (!string.endsWith("\n")) {
            string = String.valueOf(string) + "\n";
        }
        if (this.displays.size() == 0) {
            this.bufferOutput(string);
        } else {
            for (IConsoleDisplay iConsoleDisplay : this.displays) {
                iConsoleDisplay.printDebug(string);
            }
            this.eventManager.fireEvent((IEvent)new ConsoleOutputEvent(string, false));
        }
    }

    public synchronized void error(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (!string.endsWith("\n")) {
            string = String.valueOf(string) + "\n";
        }
        if (this.displays.size() == 0) {
            this.bufferError(string);
        } else {
            for (IConsoleDisplay iConsoleDisplay : this.displays) {
                iConsoleDisplay.printError(string);
            }
            this.eventManager.fireEvent((IEvent)new ConsoleOutputEvent(string, true));
        }
    }

    private void bufferOutput(String string) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new StringBuilder();
        }
        this.appendBuffer(string, this.outputBuffer);
    }

    private void bufferError(String string) {
        if (this.errorBuffer == null) {
            this.errorBuffer = new StringBuilder();
        }
        this.appendBuffer(string, this.errorBuffer);
    }

    private void appendBuffer(String string, StringBuilder stringBuilder) {
        int n;
        if (string == null) {
            return;
        }
        if (string.length() > 8192) {
            string = string.substring(0, 8192);
        }
        if ((n = stringBuilder.length() + string.length()) > 8192) {
            int n2 = n - 8192;
            stringBuilder.delete(0, n2);
        }
        stringBuilder.append(string);
    }

    public synchronized void registerDisplay(IConsoleDisplay iConsoleDisplay) {
        this.displays.add(iConsoleDisplay);
        if (this.displays.size() == 1) {
            if (this.errorBuffer != null) {
                iConsoleDisplay.printError(this.errorBuffer.toString());
                this.eventManager.fireEvent((IEvent)new ConsoleOutputEvent(this.errorBuffer.toString(), true));
                this.errorBuffer = null;
            }
            if (this.outputBuffer != null) {
                iConsoleDisplay.printOutput(this.outputBuffer.toString());
                this.eventManager.fireEvent((IEvent)new ConsoleOutputEvent(this.outputBuffer.toString(), false));
                this.outputBuffer = null;
            }
        }
    }

    public void addConsoleOutputListener(IEventHandler iEventHandler) {
        this.eventManager.addListener(iEventHandler);
    }

    public void removeConsoleOutputListener(IEventHandler iEventHandler) {
        this.eventManager.removeListener(iEventHandler);
    }
}

