/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.workspaces;

import com.subgraph.vega.application.workspaces.SwitchWorkspaceHandler;
import com.subgraph.vega.application.workspaces.WorkspaceOpenException;
import com.subgraph.vega.application.workspaces.WorkspaceRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WorkspaceChooser {
    private static final String NAME_FILE = ".name";
    private static final String AUTOSTART_FILE = ".autostart";

    public URL choose() {
        List<WorkspaceRecord> list = this.findAllWorkspaces();
        WorkspaceRecord workspaceRecord = list.size() == 1 ? list.get(0) : (list.isEmpty() ? WorkspaceChooser.createWorkspace("Default", false) : this.getAutoStartWorkspace(list));
        if (workspaceRecord == null) {
            workspaceRecord = SwitchWorkspaceHandler.openChoseWorkspaceDialog(false);
        }
        if (workspaceRecord != null) {
            return workspaceRecord.getURL();
        }
        return null;
    }

    public WorkspaceRecord getAutoStartWorkspace(List<WorkspaceRecord> list) {
        WorkspaceRecord workspaceRecord = null;
        for (WorkspaceRecord workspaceRecord2 : list) {
            if (!workspaceRecord2.isAutostart()) continue;
            if (workspaceRecord == null) {
                workspaceRecord = workspaceRecord2;
            }
            this.unlinkAutostart(workspaceRecord2.getPath());
        }
        return workspaceRecord;
    }

    public List<WorkspaceRecord> findAllWorkspaces() {
        File file = WorkspaceChooser.getBaseDirectory();
        ArrayList<WorkspaceRecord> arrayList = new ArrayList<WorkspaceRecord>();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (this.isWorkspace(file2)) {
                arrayList.add(new WorkspaceRecord(this.getWorkspaceName(file2), file2, this.isAutostart(file2)));
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean isWorkspace(File file) {
        File file2 = new File(file, NAME_FILE);
        return file2.exists();
    }

    private boolean isAutostart(File file) {
        File file2 = new File(file, AUTOSTART_FILE);
        return file2.exists();
    }

    private boolean unlinkAutostart(File file) {
        File file2 = new File(file, AUTOSTART_FILE);
        return file2.delete();
    }

    private String getWorkspaceName(File file) {
        File file2 = new File(file, NAME_FILE);
        try {
            return this.readWorkspaceName(file2);
        }
        catch (IOException iOException) {
            throw new WorkspaceOpenException("Error reading workspace name file : " + iOException.getMessage());
        }
    }

    private String readWorkspaceName(File file) throws IOException {
        String string;
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            string = bufferedReader.readLine();
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static File getBaseDirectory() {
        File file = new File(System.getProperty("user.home"));
        if (!file.canWrite()) {
            throw new WorkspaceOpenException("Cannot write to home directory " + file.getPath());
        }
        File file2 = new File(file, ".vega");
        if (!file2.exists() && !file2.mkdir()) {
            throw new WorkspaceOpenException("Could not create directory: " + file2.getPath());
        }
        return file2;
    }

    public static WorkspaceRecord createWorkspace(String string, boolean bl) {
        File file;
        File file2 = WorkspaceChooser.getBaseDirectory();
        int n = 0;
        while ((file = new File(file2, String.format("%02d", n))).exists()) {
            ++n;
        }
        if (!file.mkdir()) {
            throw new WorkspaceOpenException("Could not create directory: " + file.getPath());
        }
        try {
            WorkspaceChooser.writeNameFile(file, string);
        }
        catch (IOException iOException) {
            throw new WorkspaceOpenException("Error writing name file to workspace directory " + iOException.getMessage());
        }
        if (bl) {
            WorkspaceChooser.markAutostart(file);
        }
        return new WorkspaceRecord(string, file, bl);
    }

    public static void markAutostart(File file) {
        File file2 = new File(file, AUTOSTART_FILE);
        if (!file2.exists() && !file2.mkdir()) {
            throw new WorkspaceOpenException("Could not create autostart directory: " + file2.getPath());
        }
    }

    public static void writeNameFile(File file, String string) throws IOException {
        File file2 = new File(file, NAME_FILE);
        FileWriter fileWriter = new FileWriter(file2);
        try {
            fileWriter.write(string);
        }
        catch (Throwable throwable) {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {}
    }
}

