/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application.console;

import com.subgraph.vega.api.console.ConsoleOutputEvent;
import com.subgraph.vega.api.console.IConsole;
import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.application.Activator;
import com.subgraph.vega.ui.util.images.ImageCache;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.console.ConsoleView;

public class VegaConsoleView
extends ConsoleView
implements IEventHandler {
    public static final String ID = "com.subgraph.vega.views.VegaConsole";
    private static final int BLINK_INTERVAL = 500;
    private static final String CONSOLE_ICON = "icons/console.png";
    private static final String CONSOLE_ERROR = "icons/console_error.png";
    private static final String CONSOLE_NOTIFY = "icons/console_lightbulb.png";
    private final Timer consoleBlinkTimer = new Timer();
    private TimerTask consoleBlinkTask;
    private final ImageCache imageCache = new ImageCache("com.subgraph.vega.application");
    private IPartListener2 partListener;
    private boolean isVisible;
    private ConsoleNotifyLevel notifyLevel = ConsoleNotifyLevel.NOTIFY_OFF;

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        IConsole iConsole = Activator.getDefault().getConsole();
        if (iConsole != null) {
            iConsole.addConsoleOutputListener((IEventHandler)this);
        }
        this.partListener = this.createPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
    }

    private IPartListener2 createPartListener() {
        return new IPartListener2(){

            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                if (VegaConsoleView.ID.equals(iWorkbenchPartReference.getId())) {
                    VegaConsoleView.this.isVisible = true;
                    VegaConsoleView.this.setNotifyOff();
                }
            }

            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                if (VegaConsoleView.ID.equals(iWorkbenchPartReference.getId())) {
                    VegaConsoleView.this.isVisible = false;
                }
            }

            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }
        };
    }

    public void dispose() {
        IConsole iConsole = Activator.getDefault().getConsole();
        if (iConsole != null) {
            iConsole.removeConsoleOutputListener((IEventHandler)this);
        }
        this.getSite().getPage().removePartListener(this.partListener);
        this.imageCache.dispose();
        super.dispose();
    }

    public void startErrorNotify() {
        if (this.consoleBlinkTask == null) {
            this.consoleBlinkTask = this.createAlertTask();
            this.consoleBlinkTimer.scheduleAtFixedRate(this.consoleBlinkTask, 0L, 500L);
        }
    }

    public void stopErrorNotify() {
        if (this.consoleBlinkTask != null) {
            this.consoleBlinkTask.cancel();
            this.consoleBlinkTask = null;
        }
    }

    private TimerTask createAlertTask() {
        return new TimerTask(){
            private boolean state;

            @Override
            public void run() {
                boolean bl = this.state = !this.state;
                if (this.state) {
                    VegaConsoleView.this.setLabelImage(VegaConsoleView.this.imageCache.get(VegaConsoleView.CONSOLE_ERROR));
                } else {
                    VegaConsoleView.this.setLabelImage(VegaConsoleView.this.imageCache.get(VegaConsoleView.CONSOLE_ICON));
                }
            }
        };
    }

    private synchronized void setNotifyOff() {
        if (this.notifyLevel == ConsoleNotifyLevel.NOTIFY_ERROR) {
            this.stopErrorNotify();
        }
        this.setLabelImage(this.imageCache.get(CONSOLE_ICON));
        this.notifyLevel = ConsoleNotifyLevel.NOTIFY_OFF;
    }

    private synchronized void setNotifyOutput() {
        if (this.notifyLevel == ConsoleNotifyLevel.NOTIFY_OFF) {
            this.setLabelImage(this.imageCache.get(CONSOLE_NOTIFY));
            this.notifyLevel = ConsoleNotifyLevel.NOTIFY_OUTPUT;
        }
    }

    private synchronized void setNotifyError() {
        if (this.notifyLevel != ConsoleNotifyLevel.NOTIFY_ERROR) {
            this.startErrorNotify();
            this.notifyLevel = ConsoleNotifyLevel.NOTIFY_ERROR;
        }
    }

    private void setLabelImage(final Image image) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (image != null && !image.isDisposed()) {
                    VegaConsoleView.this.setTitleImage(image);
                }
            }
        });
    }

    public void handleEvent(IEvent iEvent) {
        if (iEvent instanceof ConsoleOutputEvent) {
            this.handleConsoleOutput((ConsoleOutputEvent)iEvent);
        }
    }

    private void handleConsoleOutput(ConsoleOutputEvent consoleOutputEvent) {
        if (!this.isVisible) {
            if (consoleOutputEvent.isErrorOutput()) {
                this.setNotifyError();
            } else {
                this.setNotifyOutput();
            }
        }
    }

    private static enum ConsoleNotifyLevel {
        NOTIFY_OFF,
        NOTIFY_OUTPUT,
        NOTIFY_ERROR;

    }
}

