/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.application;

import com.subgraph.vega.application.Activator;
import com.subgraph.vega.application.ApplicationActionBarAdvisor;
import com.subgraph.vega.application.update.UpdateCheckTask;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.PerspectiveBarManager;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        super(iWorkbenchWindowConfigurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        return new ApplicationActionBarAdvisor(iActionBarConfigurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer = this.getWindowConfigurer();
        iWorkbenchWindowConfigurer.setInitialSize(new Point(1200, 900));
        iWorkbenchWindowConfigurer.setShowCoolBar(true);
        iWorkbenchWindowConfigurer.setShowPerspectiveBar(true);
        iWorkbenchWindowConfigurer.setShowStatusLine(true);
        iWorkbenchWindowConfigurer.setShowMenuBar(true);
        iWorkbenchWindowConfigurer.setShowFastViewBars(true);
        PlatformUI.getPreferenceStore().setValue("DOCK_PERSPECTIVE_BAR", "topRight");
        PlatformUI.getPreferenceStore().setValue("SHOW_MEMORY_MONITOR", true);
        PlatformUI.getPreferenceStore().setValue("PERSPECTIVE_BAR_EXTRAS", "com.subgraph.vega.perspectives.scanner, com.subgraph.vega.perspectives.proxy");
        PlatformUI.getPreferenceStore().setValue("disableNewFastView", true);
        PlatformUI.getPreferenceStore().setValue("SHOW_OPEN_ON_PERSPECTIVE_BAR", false);
        PlatformUI.getPreferenceStore().setValue("PERSPECTIVE_BAR_SIZE", 100);
    }

    private void disablePerspectiveToolbarMenu() {
        PerspectiveBarManager perspectiveBarManager = ((WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getPerspectiveBar();
        if (perspectiveBarManager != null) {
            ToolBar toolBar = perspectiveBarManager.getControl();
            Listener[] listenerArray = toolBar.getListeners(35);
            if (listenerArray == null) {
                return;
            }
            Listener[] listenerArray2 = listenerArray;
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray2[n2];
                toolBar.removeListener(35, listener);
                ++n2;
            }
        }
    }

    public void postWindowOpen() {
        this.disablePerspectiveToolbarMenu();
        IWorkbenchWindow iWorkbenchWindow = this.getWindowConfigurer().getWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        this.forceActivate(iWorkbenchPage, "com.subgraph.vega.views.VegaConsole");
        this.forceActivate(iWorkbenchPage, "com.subgraph.vega.views.alert");
        this.maybePerformUpdateCheck(iWorkbenchWindow.getShell(), 130);
    }

    private void forceActivate(IWorkbenchPage iWorkbenchPage, String string) {
        IViewReference iViewReference = iWorkbenchPage.findViewReference(string);
        if (iViewReference != null) {
            iViewReference.getView(true);
        }
    }

    private void maybePerformUpdateCheck(Shell shell, int n) {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        if (iPreferenceStore.getBoolean("vega.preferences.updateCheck") && n != 0) {
            UpdateCheckTask updateCheckTask = new UpdateCheckTask(shell, n);
            Thread thread = new Thread(updateCheckTask);
            thread.start();
        }
    }
}

