/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.HTMLElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLFormElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLSelectElementImpl;
import org.jsoup.nodes.Element;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLFormElement;
import org.w3c.dom.html2.HTMLOptionElement;

public class HTMLOptionElementImpl
extends HTMLElementImpl
implements HTMLOptionElement {
    private final HTMLSelectElementImpl select;
    private final HTMLFormElement form;
    private final int index;

    HTMLOptionElementImpl(Element element, HTMLSelectElementImpl hTMLSelectElementImpl, int n, Document document) {
        super(element, document);
        this.select = hTMLSelectElementImpl;
        this.form = hTMLSelectElementImpl.getForm();
        this.index = n;
    }

    HTMLOptionElementImpl(Element element, Document document) {
        super(element, document);
        Element element2 = HTMLElementImpl.findEnclosingFormElement(element);
        this.form = new HTMLFormElementImpl(element2, document);
        Element element3 = HTMLElementImpl.findEnclosingSelectElement(element);
        this.select = new HTMLSelectElementImpl(element3, this.form, document);
        this.index = this.calculateIndex(element);
    }

    private int calculateIndex(Element element) {
        Element element2 = element;
        int n = 0;
        while (element2.previousElementSibling() != null) {
            element2 = element2.previousElementSibling();
            ++n;
        }
        return n;
    }

    @Override
    public HTMLFormElement getForm() {
        return this.form;
    }

    @Override
    public boolean getDefaultSelected() {
        return this.hasAttribute("selected");
    }

    @Override
    public void setDefaultSelected(boolean bl) {
    }

    @Override
    public String getText() {
        return this.getTextContent();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    @Override
    public void setDisabled(boolean bl) {
    }

    @Override
    public String getLabel() {
        return this.getAttribute("label");
    }

    @Override
    public void setLabel(String string) {
    }

    @Override
    public boolean getSelected() {
        return this.hasAttribute("selected") || this.select.getSelectedIndex() == this.index;
    }

    @Override
    public void setSelected(boolean bl) {
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    @Override
    public void setValue(String string) {
    }
}

