/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.api.html.IInnerHtmlProvidingElement;
import com.subgraph.vega.internal.html.dom.ElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLAnchorElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLFormElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLInputElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLOptionElementImpl;
import com.subgraph.vega.internal.html.dom.HTMLSelectElementImpl;
import org.jsoup.nodes.Element;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLElement;

public class HTMLElementImpl
extends ElementImpl
implements HTMLElement,
IInnerHtmlProvidingElement {
    static Element findEnclosingFormElement(Element element) {
        Element element2 = element;
        while (element2 != null) {
            if (element2.tagName().toUpperCase().equals("FORM")) {
                return element2;
            }
            element2 = element2.parent();
        }
        return null;
    }

    static Element findEnclosingSelectElement(Element element) {
        Element element2 = element;
        while (element2 != null) {
            if (element2.tagName().toUpperCase().equals("SELECT")) {
                return element2;
            }
            element2 = element2.parent();
        }
        return null;
    }

    static HTMLElementImpl create(Element element, Document document) {
        String string = element.tagName().toUpperCase();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("FORM")) {
            return new HTMLFormElementImpl(element, document);
        }
        if (string.equals("INPUT")) {
            Element element2 = HTMLElementImpl.findEnclosingFormElement(element);
            if (element2 == null) {
                return new HTMLInputElementImpl(element, null, document);
            }
            HTMLFormElementImpl hTMLFormElementImpl = new HTMLFormElementImpl(element2, document);
            return new HTMLInputElementImpl(element, hTMLFormElementImpl, document);
        }
        if (string.equals("A")) {
            return new HTMLAnchorElementImpl(element, document);
        }
        if (string.equals("OPTION")) {
            return new HTMLOptionElementImpl(element, document);
        }
        if (string.equals("SELECT")) {
            return new HTMLSelectElementImpl(element, document);
        }
        return new HTMLElementImpl(element, document);
    }

    HTMLElementImpl(Element element, Document document) {
        super(element, document);
    }

    @Override
    public String getId() {
        return this.jsoupElement.attr("id");
    }

    @Override
    public void setId(String string) {
    }

    @Override
    public String getTitle() {
        return this.jsoupElement.attr("title");
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String getLang() {
        return this.jsoupElement.attr("lang");
    }

    @Override
    public void setLang(String string) {
    }

    @Override
    public String getDir() {
        return this.jsoupElement.attr("dir");
    }

    @Override
    public void setDir(String string) {
    }

    @Override
    public String getClassName() {
        return this.jsoupElement.attr("class");
    }

    @Override
    public void setClassName(String string) {
    }

    protected int getIntAttribute(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public String getInnerHtml() {
        return this.jsoupElement.html();
    }
}

