/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.html.dom;

import com.subgraph.vega.internal.html.dom.DomImplementationImpl;
import com.subgraph.vega.internal.html.dom.HTMLElementImpl;
import com.subgraph.vega.internal.html.dom.NodeImpl;
import com.subgraph.vega.internal.html.dom.NodeListImpl;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements org.w3c.dom.Document {
    private static final DOMImplementation implementation = new DomImplementationImpl();
    protected final Document jsoupDocument;
    private Element cachedOwnerDocument;

    protected DocumentImpl(Document document) {
        super((Node)document, null);
        this.jsoupDocument = document;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public DocumentType getDoctype() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public DOMImplementation getImplementation() {
        return implementation;
    }

    @Override
    public Element getDocumentElement() {
        if (this.cachedOwnerDocument != null) {
            return this.cachedOwnerDocument;
        }
        org.jsoup.nodes.Element element = this.jsoupDocument.select("html").first();
        if (element == null) {
            return null;
        }
        this.cachedOwnerDocument = HTMLElementImpl.create(this.jsoupDocument.select("html").first(), this.getOwnerDocument());
        return this.cachedOwnerDocument;
    }

    @Override
    public Element createElement(String string) throws DOMException {
        throw DocumentImpl.createReadOnlyException();
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw DocumentImpl.createReadOnlyException();
    }

    @Override
    public Text createTextNode(String string) {
        throw DocumentImpl.createReadOnlyException();
    }

    @Override
    public Comment createComment(String string) {
        throw DocumentImpl.createReadOnlyException();
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        throw DocumentImpl.createNoXMLSupportException();
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw DocumentImpl.createNoXMLSupportException();
    }

    @Override
    public Attr createAttribute(String string) throws DOMException {
        throw DocumentImpl.createReadOnlyException();
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        throw DocumentImpl.createNoXMLSupportException();
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        Element element = this.getDocumentElement();
        if (element == null) {
            return NodeListImpl.emptyList;
        }
        return element.getElementsByTagName(string);
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node node, boolean bl) throws DOMException {
        throw DocumentImpl.createReadOnlyException();
    }

    @Override
    public Element createElementNS(String string, String string2) throws DOMException {
        throw DocumentImpl.createNoXMLSupportException();
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        throw DocumentImpl.createNoXMLSupportException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        throw DocumentImpl.createNoXMLSupportException();
    }

    @Override
    public Element getElementById(String string) {
        Element element = this.getDocumentElement();
        if (element == null) {
            return null;
        }
        org.jsoup.nodes.Element element2 = this.jsoupDocument.getElementById(string);
        if (element2 == null) {
            return null;
        }
        return HTMLElementImpl.create(element2, this);
    }

    @Override
    public String getInputEncoding() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public String getXmlEncoding() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public boolean getXmlStandalone() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public String getXmlVersion() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public String getDocumentURI() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public void setDocumentURI(String string) {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node node) throws DOMException {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public void normalizeDocument() {
        throw DocumentImpl.createNoLevel3SupportException();
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node node, String string, String string2) throws DOMException {
        throw DocumentImpl.createNoLevel3SupportException();
    }
}

