/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.statusview;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.http.proxy.IHttpProxyListener;
import com.subgraph.vega.api.http.proxy.IHttpProxyService;
import com.subgraph.vega.api.http.proxy.IHttpProxyServiceEventHandler;
import com.subgraph.vega.api.http.requests.IHttpRequestTask;
import com.subgraph.vega.api.http.requests.RequestTaskStartEvent;
import com.subgraph.vega.api.http.requests.RequestTaskStopEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RequestStatusTableContentProvider
implements IStructuredContentProvider,
IEventHandler {
    private static final long REQUEST_EXPIRY = 15000L;
    private final IHttpProxyServiceEventHandler proxyServiceEventHandler = new IHttpProxyServiceEventHandler(){

        public void notifyStart(int n) {
        }

        public void notifyStartListener(IHttpProxyListener iHttpProxyListener) {
            RequestStatusTableContentProvider.this.registerProxyListener(iHttpProxyListener);
        }

        public void notifyStop() {
        }

        public void notifyStopListener(IHttpProxyListener iHttpProxyListener) {
            RequestStatusTableContentProvider.this.unregisterProxyListener(iHttpProxyListener, true);
        }

        public void notifyConfigChange(int n) {
        }
    };
    private final Timer refreshTimer = new Timer();
    private TimerTask refreshTimerTask;
    private Viewer viewer;
    private IHttpProxyService proxyService;
    private final List<IHttpProxyListener> listenerList = new ArrayList<IHttpProxyListener>();
    private final List<IHttpRequestTask> requestList = new ArrayList<IHttpRequestTask>();
    private int requestListExpiryIdx = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        for (IHttpProxyListener requestStatusTableContentProvider2 : this.listenerList) {
            this.unregisterProxyListener(requestStatusTableContentProvider2, false);
        }
        RequestStatusTableContentProvider requestStatusTableContentProvider = this;
        synchronized (requestStatusTableContentProvider) {
            this.listenerList.clear();
        }
        if (this.proxyService != null) {
            this.proxyService.unregisterEventHandler(this.proxyServiceEventHandler);
            this.proxyService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object object, Object object2) {
        RequestStatusTableContentProvider requestStatusTableContentProvider = this;
        synchronized (requestStatusTableContentProvider) {
            this.viewer = viewer;
            if (this.proxyService != null) {
                this.proxyService.unregisterEventHandler(this.proxyServiceEventHandler);
                for (IHttpProxyListener iHttpProxyListener : this.listenerList) {
                    this.unregisterProxyListener(iHttpProxyListener, false);
                }
                this.listenerList.clear();
                this.requestList.clear();
                this.requestListExpiryIdx = 0;
            }
            this.proxyService = (IHttpProxyService)object2;
            if (this.proxyService != null) {
                this.proxyService.registerEventHandler(this.proxyServiceEventHandler);
                IHttpProxyListener[] iHttpProxyListenerArray = this.proxyService.getListeners();
                int n = iHttpProxyListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IHttpProxyListener iHttpProxyListener;
                    iHttpProxyListener = iHttpProxyListenerArray[n2];
                    this.registerProxyListener(iHttpProxyListener);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object object) {
        RequestStatusTableContentProvider requestStatusTableContentProvider = this;
        synchronized (requestStatusTableContentProvider) {
            return this.requestList.toArray(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(IEvent iEvent) {
        RequestStatusTableContentProvider requestStatusTableContentProvider = this;
        synchronized (requestStatusTableContentProvider) {
            IHttpRequestTask iHttpRequestTask;
            int n;
            if (iEvent instanceof RequestTaskStartEvent) {
                this.requestList.add(0, ((RequestTaskStartEvent)iEvent).getRequestTask());
                ++this.requestListExpiryIdx;
            } else if (iEvent instanceof RequestTaskStopEvent && (n = this.requestList.indexOf(iHttpRequestTask = ((RequestTaskStopEvent)iEvent).getRequestTask())) != -1) {
                --this.requestListExpiryIdx;
                this.requestList.remove(n);
                this.requestList.add(this.requestListExpiryIdx, iHttpRequestTask);
                if (this.refreshTimerTask == null) {
                    this.refreshTimerTask = this.createRefreshTask();
                    this.refreshTimer.schedule(this.refreshTimerTask, 15000L);
                }
            }
            if (this.viewer != null) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RequestStatusTableContentProvider.this.viewer.refresh();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProxyListener(IHttpProxyListener iHttpProxyListener) {
        RequestStatusTableContentProvider requestStatusTableContentProvider = this;
        synchronized (requestStatusTableContentProvider) {
            this.listenerList.add(iHttpProxyListener);
        }
        iHttpProxyListener.getRequestEngine().addRequestListener((IEventHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterProxyListener(IHttpProxyListener iHttpProxyListener, boolean bl) {
        iHttpProxyListener.getRequestEngine().removeRequestListener((IEventHandler)this);
        if (bl) {
            RequestStatusTableContentProvider requestStatusTableContentProvider = this;
            synchronized (requestStatusTableContentProvider) {
                this.listenerList.remove(iHttpProxyListener);
            }
        }
    }

    private TimerTask createRefreshTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RequestStatusTableContentProvider requestStatusTableContentProvider = RequestStatusTableContentProvider.this;
                synchronized (requestStatusTableContentProvider) {
                    IHttpRequestTask iHttpRequestTask;
                    Date date = new Date();
                    int n = RequestStatusTableContentProvider.this.requestList.size() - 1;
                    while (n >= RequestStatusTableContentProvider.this.requestListExpiryIdx) {
                        iHttpRequestTask = (IHttpRequestTask)RequestStatusTableContentProvider.this.requestList.get(n);
                        long l = date.getTime() - iHttpRequestTask.getTimeCompleted().getTime();
                        if (l < 15000L) break;
                        RequestStatusTableContentProvider.this.requestList.remove(n);
                        --n;
                    }
                    if (n != RequestStatusTableContentProvider.this.requestListExpiryIdx - 1) {
                        iHttpRequestTask = (IHttpRequestTask)RequestStatusTableContentProvider.this.requestList.get(n);
                        RequestStatusTableContentProvider.this.refreshTimerTask = RequestStatusTableContentProvider.this.createRefreshTask();
                        RequestStatusTableContentProvider.this.refreshTimer.schedule(RequestStatusTableContentProvider.this.refreshTimerTask, iHttpRequestTask.getTimeCompleted().getTime() + 15000L - date.getTime());
                    } else {
                        RequestStatusTableContentProvider.this.refreshTimerTask = null;
                    }
                    if (RequestStatusTableContentProvider.this.viewer != null) {
                        RequestStatusTableContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RequestStatusTableContentProvider.this.viewer.refresh();
                            }
                        });
                    }
                }
            }
        };
    }
}

