/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.requestlogviewer;

import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.IWorkspace;
import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionIntegerMatchAction;
import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.api.model.requests.IRequestLog;
import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.api.model.tags.ITaggable;
import com.subgraph.vega.internal.ui.http.requestlogviewer.HttpViewLabelProvider;
import com.subgraph.vega.internal.ui.http.requestlogviewer.RequestViewContentProvider;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.requesteditviewer.RequestEditView;
import com.subgraph.vega.ui.http.requestlogviewer.FocusOnRecordTask;
import com.subgraph.vega.ui.http.requestlogviewer.RequestResponseViewer;
import com.subgraph.vega.ui.tags.taggableeditor.TaggableEditorDialog;
import com.subgraph.vega.ui.tagsl.taggablepopup.TaggablePopupDialog;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RequestLogViewer
extends Composite {
    public static final String POPUP_REQUESTS_TABLE = "com.subgraph.vega.ui.http.requestlogviewer.popup";
    private static final RGB ACTIVE_FILTER_COLOR = new RGB(240, 255, 255);
    private static final int MAX_OPEN_EDITORS = 3;
    private final String instanceId;
    private final int heightInRows;
    private TableViewer tableViewer;
    private Menu tableMenu;
    private RequestResponseViewer requestResponseViewer;
    private TaggablePopupDialog taggablePopupDialog;
    private RequestViewContentProvider contentProvider;
    private IHttpCondition requestIdCondition;

    public RequestLogViewer(Composite composite, String string, int n) {
        super(composite, 0);
        this.instanceId = string;
        this.heightInRows = n;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.createTable(gridData).setLayoutData((Object)gridData);
        this.tableViewer.setInput((Object)Activator.getDefault().getModel());
    }

    public void setRequestResponseViewer(RequestResponseViewer requestResponseViewer) {
        this.requestResponseViewer = requestResponseViewer;
        this.tableMenu.setEnabled(this.requestResponseViewer != null && !this.tableViewer.getSelection().isEmpty());
    }

    public void focusOnRecord(long l) {
        Object object = this.tableViewer.getInput();
        if (!(object instanceof IModel)) {
            return;
        }
        IModel iModel = (IModel)object;
        IWorkspace iWorkspace = iModel.getCurrentWorkspace();
        if (iWorkspace == null) {
            return;
        }
        this.addRequestIdConditionRule(l);
        IRequestLog iRequestLog = iWorkspace.getRequestLog();
        IRequestLogRecord iRequestLogRecord = iRequestLog.lookupRecord(l);
        if (iRequestLogRecord == null) {
            return;
        }
        FocusOnRecordTask focusOnRecordTask = new FocusOnRecordTask(iRequestLogRecord, this.contentProvider, this.tableViewer);
        new Thread(focusOnRecordTask).start();
        if (this.requestResponseViewer != null) {
            this.requestResponseViewer.setDisplayResponse();
        }
    }

    private void addRequestIdConditionRule(long l) {
        if (this.contentProvider == null || this.contentProvider.getConditionSet() == null) {
            return;
        }
        IHttpConditionSet iHttpConditionSet = this.contentProvider.getConditionSet();
        IHttpConditionType iHttpConditionType = iHttpConditionSet.getConditionManager().getConditionTypeByName("request id");
        IHttpConditionMatchAction iHttpConditionMatchAction = iHttpConditionType.getMatchActionByName("equals");
        ((IHttpConditionIntegerMatchAction)iHttpConditionMatchAction).setInteger((int)l);
        if (this.requestIdCondition != null) {
            iHttpConditionSet.removeTemporaryCondition(this.requestIdCondition, false);
        }
        this.requestIdCondition = iHttpConditionType.createConditionInstance(iHttpConditionMatchAction);
        this.requestIdCondition.setSufficient(true);
        iHttpConditionSet.appendTemporaryCondition(this.requestIdCondition, true);
    }

    private Composite createTable(GridData gridData) {
        Composite composite = new Composite((Composite)this, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(composite, 0x10010002);
        this.createColumns(this.tableViewer, tableColumnLayout);
        Color color = new Color((Device)this.tableViewer.getControl().getDisplay(), ACTIVE_FILTER_COLOR);
        this.contentProvider = new RequestViewContentProvider(this.instanceId, color);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HttpViewLabelProvider());
        this.tableViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        Table table = this.tableViewer.getTable();
        table.setMenu(this.createTableMenu(table));
        table.addMouseTrackListener(this.createTableMouseTrackListener());
        table.addMouseMoveListener(this.createMouseMoveListener());
        if (this.heightInRows != 0) {
            gridData.heightHint = table.getItemHeight() * this.heightInRows;
        }
        return composite;
    }

    private void createColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"ID", "Host", "Method", "Request", "Status", "Length", "Time (ms)", "Tags"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(60, true, true), new ColumnPixelData(120, true, true), new ColumnPixelData(60, true, true), new ColumnWeightData(100, 100, true), new ColumnPixelData(50, true, true), new ColumnPixelData(80, true, true), new ColumnPixelData(50, true, true), new ColumnPixelData(15, true, true)};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            ++n;
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                RequestLogViewer.this.tableMenu.setEnabled(RequestLogViewer.this.requestResponseViewer != null && !selectionChangedEvent.getSelection().isEmpty());
                if (RequestLogViewer.this.requestResponseViewer != null) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    if (iStructuredSelection.getFirstElement() instanceof IRequestLogRecord) {
                        RequestLogViewer.this.requestResponseViewer.setCurrentRecord((IRequestLogRecord)iStructuredSelection.getFirstElement());
                    } else {
                        RequestLogViewer.this.requestResponseViewer.setCurrentRecord(null);
                    }
                }
            }
        };
    }

    private Menu createTableMenu(Table table) {
        this.tableMenu = new Menu((Control)table);
        this.tableMenu.setEnabled(false);
        MenuItem menuItem = new MenuItem(this.tableMenu, 64);
        menuItem.setText("Replay Request");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RequestLogViewer.this.replayRequestSelection();
            }
        });
        MenuItem menuItem2 = new MenuItem(this.tableMenu, 64);
        menuItem2.setText("Edit Tag");
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RequestLogViewer.this.tagEditSelection();
            }
        });
        return this.tableMenu;
    }

    private void replayRequestSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        if (iStructuredSelection.size() > 3) {
            MessageBox messageBox = new MessageBox(this.getShell(), 296);
            messageBox.setText("Warning");
            messageBox.setMessage(String.valueOf(iStructuredSelection.size()) + " replay editors will be opened. Proceed?");
            if (messageBox.open() == 256) {
                return;
            }
        }
        int n = 1;
        for (IRequestLogRecord iRequestLogRecord : iStructuredSelection) {
            RequestEditView requestEditView;
            String string = UUID.randomUUID().toString();
            try {
                requestEditView = (RequestEditView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.subgraph.vega.views.requestEdit", string, n);
            }
            catch (PartInitException partInitException) {
                ErrorDialog.displayExceptionError((Shell)this.getShell(), (Exception)((Object)partInitException));
                return;
            }
            try {
                requestEditView.setRequest(iRequestLogRecord);
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorDialog.displayExceptionError((Shell)this.getShell(), (Exception)uRISyntaxException);
                return;
            }
            n = 2;
        }
    }

    private void tagEditSelection() {
        IRequestLogRecord iRequestLogRecord = (IRequestLogRecord)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        TaggableEditorDialog taggableEditorDialog = TaggableEditorDialog.createDialog((Shell)this.getShell(), (ITaggable)iRequestLogRecord);
        if (taggableEditorDialog.open() == 0) {
            this.tableViewer.refresh();
        }
    }

    public List<IRequestLogRecord> getSelectionList() {
        return ((IStructuredSelection)this.tableViewer.getSelection()).toList();
    }

    private MouseMoveListener createMouseMoveListener() {
        return new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (RequestLogViewer.this.taggablePopupDialog != null) {
                    RequestLogViewer.this.taggablePopupDialog.close();
                    RequestLogViewer.this.taggablePopupDialog = null;
                }
            }
        };
    }

    private MouseTrackListener createTableMouseTrackListener() {
        return new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
                if (RequestLogViewer.this.taggablePopupDialog != null) {
                    RequestLogViewer.this.taggablePopupDialog.close();
                    RequestLogViewer.this.taggablePopupDialog = null;
                }
            }

            public void mouseHover(MouseEvent mouseEvent) {
                if (RequestLogViewer.this.taggablePopupDialog == null) {
                    IRequestLogRecord iRequestLogRecord;
                    Point point = new Point(mouseEvent.x, mouseEvent.y);
                    Table table = RequestLogViewer.this.tableViewer.getTable();
                    TableItem tableItem = table.getItem(point);
                    if (tableItem != null && (iRequestLogRecord = (IRequestLogRecord)tableItem.getData()).getTagCount() > 0) {
                        Point point2 = RequestLogViewer.this.tableViewer.getTable().getDisplay().map((Control)table.getParent(), null, mouseEvent.x, mouseEvent.y);
                        RequestLogViewer.this.taggablePopupDialog = new TaggablePopupDialog(table.getShell(), (ITaggable)iRequestLogRecord, point2);
                        RequestLogViewer.this.taggablePopupDialog.open();
                    }
                }
            }
        };
    }
}

