/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.requestlogviewer;

import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import com.subgraph.vega.internal.ui.http.requestlogviewer.RequestViewContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class FocusOnRecordTask
implements Runnable {
    private final IRequestLogRecord record;
    private final RequestViewContentProvider contentProvider;
    private final TableViewer tableViewer;

    FocusOnRecordTask(IRequestLogRecord iRequestLogRecord, RequestViewContentProvider requestViewContentProvider, TableViewer tableViewer) {
        this.record = iRequestLogRecord;
        this.contentProvider = requestViewContentProvider;
        this.tableViewer = tableViewer;
    }

    @Override
    public void run() {
        final int n = this.contentProvider.getRowForRecord(this.record);
        if (n == -1) {
            return;
        }
        final Table table = this.tableViewer.getTable();
        Display display = table.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (table.isDisposed()) {
                        return;
                    }
                    int n2 = FocusOnRecordTask.this.calculateTopRow(n);
                    table.setTopIndex(n2);
                    FocusOnRecordTask.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)FocusOnRecordTask.this.record), false);
                }
            });
        }
    }

    private int calculateTopRow(int n) {
        int n2 = this.rowsVisible();
        int n3 = n2 / 2;
        if (n3 > n) {
            return 0;
        }
        return n - n3;
    }

    private int rowsVisible() {
        Table table = this.tableViewer.getTable();
        int n = table.getItemHeight();
        int n2 = table.getClientArea().height - table.getHeaderHeight();
        return n2 / n;
    }
}

