/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.requestfilters;

import com.subgraph.vega.api.model.conditions.IHttpCondition;
import com.subgraph.vega.api.model.conditions.IHttpConditionSet;
import com.subgraph.vega.api.model.conditions.IHttpConditionType;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ConditionTreeContentProvider
implements ITreeContentProvider {
    private IHttpConditionSet conditionSet;
    private Map<IHttpConditionType, List<IHttpCondition>> conditionTypeMap = new IdentityHashMap<IHttpConditionType, List<IHttpCondition>>();

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.conditionSet = (IHttpConditionSet)object2;
        this.conditionTypeMap.clear();
    }

    public Object[] getElements(Object object) {
        this.conditionTypeMap.clear();
        for (IHttpCondition iHttpCondition : this.conditionSet.getAllConditions()) {
            List<IHttpCondition> list = this.conditionTypeMap.get(iHttpCondition.getType());
            if (list == null) {
                list = new ArrayList<IHttpCondition>();
                this.conditionTypeMap.put(iHttpCondition.getType(), list);
            }
            list.add(iHttpCondition);
        }
        return this.conditionTypeMap.keySet().toArray(new IHttpConditionType[0]);
    }

    public Object[] getChildren(Object object) {
        List<IHttpCondition> list;
        if (object instanceof IHttpConditionType && (list = this.conditionTypeMap.get(object)) != null) {
            return list.toArray(new IHttpCondition[0]);
        }
        return null;
    }

    public Object getParent(Object object) {
        if (object instanceof IHttpCondition) {
            return ((IHttpCondition)object).getType();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return object instanceof IHttpConditionType;
    }
}

