/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.request.view;

import com.subgraph.vega.api.events.IEvent;
import com.subgraph.vega.api.events.IEventHandler;
import com.subgraph.vega.api.http.proxy.IHttpProxyService;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.api.model.WorkspaceCloseEvent;
import com.subgraph.vega.api.model.WorkspaceResetEvent;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.request.view.WebEntitySelectionListener;
import com.subgraph.vega.ui.http.requestlogviewer.RequestLogViewer;
import com.subgraph.vega.ui.http.requestlogviewer.RequestResponseViewer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;

public class HttpRequestView
extends ViewPart {
    public static final String ID = "com.subgraph.vega.views.http";
    public static final String ID_PROXY_SECONDARY = "proxy";
    public static final String ID_PROXY = "com.subgraph.vega.views.http:proxy";
    private RequestLogViewer requestLogViewer;
    private RequestResponseViewer requestResponseViewer;
    private IEventHandler workspaceListener;

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(composite, 512);
        this.requestLogViewer = new RequestLogViewer((Composite)sashForm, this.getViewSite().getSecondaryId(), 0);
        this.requestResponseViewer = new RequestResponseViewer(sashForm);
        this.requestLogViewer.setRequestResponseViewer(this.requestResponseViewer);
        sashForm.setWeights(new int[]{40, 60});
        composite.pack();
        ISelectionService iSelectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        IModel iModel = Activator.getDefault().getModel();
        WebEntitySelectionListener webEntitySelectionListener = new WebEntitySelectionListener(iModel, this.getViewSite().getSecondaryId());
        iSelectionService.addSelectionListener((ISelectionListener)webEntitySelectionListener);
        this.workspaceListener = new IEventHandler(){

            public void handleEvent(IEvent iEvent) {
                if (iEvent instanceof WorkspaceCloseEvent || iEvent instanceof WorkspaceResetEvent) {
                    HttpRequestView.this.handleWorkspaceCloseOrReset();
                }
            }
        };
        iModel.addWorkspaceListener(this.workspaceListener);
    }

    private void handleWorkspaceCloseOrReset() {
        IHttpProxyService iHttpProxyService = Activator.getDefault().getProxyService();
        this.resetToggleCommand("com.subgraph.vega.commands.proxyScan", false);
        this.resetToggleCommand("com.subgraph.vega.commands.proxyPassthrough", iHttpProxyService.isPassthrough());
    }

    private void resetToggleCommand(String string, boolean bl) {
        ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand(string);
        if (command == null) {
            return;
        }
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (state != null) {
            state.setValue((Object)bl);
        }
    }

    public void focusOnRecord(long l) {
        this.requestLogViewer.focusOnRecord(l);
    }

    public void setFocus() {
        this.requestLogViewer.setFocus();
    }
}

