/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.intercept;

import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.api.model.IModel;
import com.subgraph.vega.ui.http.Activator;
import com.subgraph.vega.ui.http.builder.HeaderEditor;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import com.subgraph.vega.ui.http.builder.RequestEditor;
import com.subgraph.vega.ui.http.builder.ResponseMessageEditor;
import com.subgraph.vega.ui.http.intercept.TransactionInfo;
import com.subgraph.vega.ui.http.intercept.TransactionManager;
import com.subgraph.vega.ui.http.intercept.config.ConfigureInterceptionContent;
import com.subgraph.vega.ui.util.dialogs.ConfigDialogCreator;
import com.subgraph.vega.ui.util.dialogs.ErrorDialog;
import com.subgraph.vega.ui.util.dialogs.IConfigDialogContent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TransactionViewer
extends Composite {
    private static final Image IMAGE_CONFIGURE = Activator.getImageDescriptor("icons/interception_rules.png").createImage();
    private final IModel model;
    private final IProxyTransaction.TransactionDirection direction;
    private final TransactionInfo transactionInfo;
    private Label statusLabel;
    private ToolItem configureButton;
    private Composite viewerControl;
    private StackLayout viewerLayout;
    private Composite viewerEmpty;
    private Menu viewerMenu;
    private boolean isPending;
    private int lastTransactionSerial;
    private IHttpBuilderPart builderPartCurr;
    private Window configDialog;

    public TransactionViewer(Composite composite, IModel iModel, TransactionInfo transactionInfo, IProxyTransaction.TransactionDirection transactionDirection) {
        super(composite, 0);
        this.model = iModel;
        this.direction = transactionDirection;
        this.transactionInfo = transactionInfo;
        this.isPending = false;
        this.setLayout((Layout)this.createLayout());
        this.createStatusLabel();
        this.createToolbar();
        Group group = new Group((Composite)this, 0);
        group.setLayout((Layout)new FillLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        if (transactionDirection == IProxyTransaction.TransactionDirection.DIRECTION_REQUEST) {
            this.lastTransactionSerial = transactionInfo.getRequestTransactionSerial();
            this.createViewersRequest((Composite)group);
            this.updateViewerRequest();
        } else {
            this.lastTransactionSerial = transactionInfo.getResponseTransactionSerial();
            this.createViewersResponse((Composite)group);
            this.updateViewerResponse();
        }
    }

    public void processChanges() {
        if (this.isPending) {
            try {
                this.builderPartCurr.processContents();
            }
            catch (Exception exception) {
                ErrorDialog.displayExceptionError((Shell)this.getShell(), (Exception)exception);
            }
        }
    }

    private GridLayout createLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 2;
        return gridLayout;
    }

    private Label createStatusLabel() {
        this.statusLabel = new Label((Composite)this, 0);
        this.statusLabel.setLayoutData((Object)new GridData(4, 1024, true, false));
        return this.statusLabel;
    }

    private ToolBar createToolbar() {
        final ToolBar toolBar = new ToolBar((Composite)this, 131072);
        this.viewerMenu = new Menu((Decorations)this.getShell(), 8);
        final ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setText("View");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = toolItem.getBounds();
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                point = toolBar.toDisplay(point);
                TransactionViewer.this.viewerMenu.setLocation(point.x, point.y);
                TransactionViewer.this.viewerMenu.setVisible(true);
            }
        });
        this.configureButton = this.createToolbarButton(toolBar, IMAGE_CONFIGURE, "Configure interception rules", this.createConfigureButtonListener());
        return toolBar;
    }

    private ToolItem createToolbarButton(ToolBar toolBar, Image image, String string, SelectionListener selectionListener) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(image);
        toolItem.setToolTipText(string);
        toolItem.addSelectionListener(selectionListener);
        return toolItem;
    }

    private SelectionListener createConfigureButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransactionViewer.this.doConfigure();
            }
        };
    }

    private void createViewersRequest(Composite composite) {
        this.viewerControl = new Composite(composite, 0);
        this.viewerLayout = new StackLayout();
        this.viewerControl.setLayout((Layout)this.viewerLayout);
        IHttpRequestBuilder iHttpRequestBuilder = this.transactionInfo.getRequestBuilder();
        SelectionAdapter selectionAdapter = this.createSelectionListenerMenuItem();
        this.viewerEmpty = new Composite(this.viewerControl, 0);
        this.viewerEmpty.setLayout((Layout)new FillLayout());
        RequestEditor requestEditor = new RequestEditor(this.viewerControl, iHttpRequestBuilder);
        MenuItem menuItem = new MenuItem(this.viewerMenu, 0);
        menuItem.setText("Request");
        menuItem.setData((Object)requestEditor);
        menuItem.addSelectionListener((SelectionListener)selectionAdapter);
        this.builderPartCurr = requestEditor;
        HeaderEditor headerEditor = new HeaderEditor(this.viewerControl, (IHttpMessageBuilder)iHttpRequestBuilder, 0);
        menuItem = new MenuItem(this.viewerMenu, 0);
        menuItem.setText("Headers");
        menuItem.setData((Object)headerEditor);
        menuItem.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void createViewersResponse(Composite composite) {
        this.viewerControl = new Composite(composite, 0);
        this.viewerLayout = new StackLayout();
        this.viewerControl.setLayout((Layout)this.viewerLayout);
        IHttpResponseBuilder iHttpResponseBuilder = this.transactionInfo.getResponseBuilder();
        SelectionAdapter selectionAdapter = this.createSelectionListenerMenuItem();
        this.viewerEmpty = new Composite(this.viewerControl, 0);
        this.viewerEmpty.setLayout((Layout)new FillLayout());
        ResponseMessageEditor responseMessageEditor = new ResponseMessageEditor(this.viewerControl, iHttpResponseBuilder);
        responseMessageEditor.setEditable(false);
        MenuItem menuItem = new MenuItem(this.viewerMenu, 0);
        menuItem.setText("Response");
        menuItem.setData((Object)responseMessageEditor);
        menuItem.addSelectionListener((SelectionListener)selectionAdapter);
        this.builderPartCurr = responseMessageEditor;
        HeaderEditor headerEditor = new HeaderEditor(this.viewerControl, (IHttpMessageBuilder)iHttpResponseBuilder, 0);
        headerEditor.setEditable(false);
        menuItem = new MenuItem(this.viewerMenu, 0);
        menuItem.setText("Headers");
        menuItem.setData((Object)headerEditor);
        menuItem.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private SelectionAdapter createSelectionListenerMenuItem() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                IHttpBuilderPart iHttpBuilderPart = (IHttpBuilderPart)menuItem.getData();
                TransactionViewer.this.processChanges();
                TransactionViewer.this.builderPartCurr = iHttpBuilderPart;
                TransactionViewer.this.builderPartCurr.setEditable(TransactionViewer.this.isPending);
                TransactionViewer.this.builderPartCurr.refresh();
                ((TransactionViewer)TransactionViewer.this).viewerLayout.topControl = TransactionViewer.this.builderPartCurr.getControl();
                TransactionViewer.this.viewerControl.layout();
            }
        };
    }

    private void doConfigure() {
        if (this.configDialog != null && this.configDialog.getShell() != null) {
            this.configDialog.close();
            this.configDialog = null;
            return;
        }
        this.configDialog = ConfigDialogCreator.createDialog((ToolItem)this.configureButton, (IConfigDialogContent)new ConfigureInterceptionContent(this.model, this.direction));
        this.configDialog.open();
    }

    private void updateViewerRequest() {
        Composite composite;
        TransactionManager.TransactionStatus transactionStatus = this.transactionInfo.getRequestStatus();
        String string = this.transactionInfo.getRequestStatusMessage();
        if (transactionStatus == TransactionManager.TransactionStatus.STATUS_INACTIVE) {
            this.isPending = false;
            composite = this.viewerEmpty;
        } else {
            this.isPending = transactionStatus == TransactionManager.TransactionStatus.STATUS_PENDING;
            composite = this.builderPartCurr.getControl();
            this.builderPartCurr.setEditable(this.isPending);
            if (this.lastTransactionSerial != this.transactionInfo.getRequestTransactionSerial()) {
                this.lastTransactionSerial = this.transactionInfo.getRequestTransactionSerial();
                this.builderPartCurr.refresh();
            }
        }
        this.statusLabel.setText(string);
        if (this.viewerLayout.topControl != composite) {
            this.viewerLayout.topControl = composite;
            this.viewerControl.layout();
        }
        this.viewerMenu.setEnabled(this.isPending);
    }

    private void updateViewerResponse() {
        Composite composite;
        TransactionManager.TransactionStatus transactionStatus = this.transactionInfo.getResponseStatus();
        String string = this.transactionInfo.getResponseStatusMessage();
        if (transactionStatus == TransactionManager.TransactionStatus.STATUS_INACTIVE) {
            this.isPending = false;
            composite = this.viewerEmpty;
        } else {
            this.isPending = transactionStatus == TransactionManager.TransactionStatus.STATUS_PENDING;
            composite = this.builderPartCurr.getControl();
            this.builderPartCurr.setEditable(this.isPending);
            if (this.lastTransactionSerial != this.transactionInfo.getResponseTransactionSerial()) {
                this.lastTransactionSerial = this.transactionInfo.getResponseTransactionSerial();
                this.builderPartCurr.refresh();
            }
        }
        this.statusLabel.setText(string);
        if (this.viewerLayout.topControl != composite) {
            this.viewerLayout.topControl = composite;
            this.viewerControl.layout();
        }
        this.viewerMenu.setEnabled(this.isPending);
    }

    public void notifyUpdate() {
        if (this.direction == IProxyTransaction.TransactionDirection.DIRECTION_REQUEST) {
            this.updateViewerRequest();
        } else {
            this.updateViewerResponse();
        }
    }
}

