/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.intercept;

import com.subgraph.vega.api.http.proxy.IHttpInterceptor;
import com.subgraph.vega.api.http.proxy.IHttpInterceptorEventHandler;
import com.subgraph.vega.api.http.proxy.IProxyTransaction;
import com.subgraph.vega.api.http.proxy.IProxyTransactionEventHandler;
import com.subgraph.vega.ui.http.intercept.InterceptView;
import com.subgraph.vega.ui.http.intercept.TransactionInfo;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class TransactionManager {
    private final Logger logger = Logger.getLogger("proxy");
    private InterceptView interceptView;
    private IHttpInterceptor interceptor;
    private IHttpInterceptorEventHandler interceptorEventHandler;
    private IProxyTransactionEventHandler transactionEventHandler;
    private IProxyTransaction currentTransaction;
    private IProxyTransaction currentRequestTransaction;
    private int currentSerial;
    private TransactionStatus requestStatus;
    private int requestTransactionSerial;
    private TransactionStatus responseStatus;
    private int responseTransactionSerial;

    TransactionManager(InterceptView interceptView, IHttpInterceptor iHttpInterceptor) {
        this.interceptView = interceptView;
        this.interceptor = iHttpInterceptor;
        this.interceptorEventHandler = new IHttpInterceptorEventHandler(){

            public void notifyQueue(IProxyTransaction iProxyTransaction, int n) {
                if (!iProxyTransaction.hasResponse()) {
                    TransactionManager.this.handleTransactionRequest(iProxyTransaction);
                } else {
                    TransactionManager.this.handleTransactionResponse(iProxyTransaction);
                }
            }

            public void notifyRemove(int n) {
            }

            public void notifyEmpty() {
            }
        };
        this.transactionEventHandler = new IProxyTransactionEventHandler(){

            public void notifyForward() {
                TransactionManager.this.handleTransactionForward();
            }

            public void notifyComplete(boolean bl) {
                TransactionManager.this.handleTransactionComplete();
            }
        };
        this.currentSerial = 0;
        this.requestStatus = TransactionStatus.STATUS_INACTIVE;
        this.requestTransactionSerial = 0;
        this.responseStatus = TransactionStatus.STATUS_INACTIVE;
        this.responseTransactionSerial = 0;
        this.getNextTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagerActive() {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            this.interceptor.addEventHandler(this.interceptorEventHandler);
            this.getNextTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openTransaction(IProxyTransaction iProxyTransaction) {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (this.currentTransaction != null) {
                if (this.currentTransaction == iProxyTransaction) {
                    return;
                }
                this.currentTransaction.setEventHandler(null);
            }
            this.setCurrentTransaction(iProxyTransaction);
            this.interceptView.notifyUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (this.interceptor != null) {
                this.interceptor.removeEventHandler(this.interceptorEventHandler);
                if (this.currentTransaction != null) {
                    this.currentTransaction.setEventHandler(null);
                    this.currentRequestTransaction = null;
                    this.currentTransaction = null;
                    ++this.currentSerial;
                    ++this.requestTransactionSerial;
                    ++this.responseTransactionSerial;
                    this.requestStatus = this.responseStatus = TransactionStatus.STATUS_INACTIVE;
                }
                this.interceptor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransactionInfo(TransactionInfo transactionInfo) {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (this.currentTransaction != null) {
                if (transactionInfo.getRequestTransactionSerial() != this.requestTransactionSerial) {
                    try {
                        transactionInfo.setFromRequest((HttpRequest)this.currentTransaction.getRequest());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.logger.log(Level.WARNING, "Error processing request, dropped transaction", uRISyntaxException);
                        this.handleBadUpdate(transactionInfo);
                        return;
                    }
                    if (this.requestStatus == TransactionStatus.STATUS_PENDING) {
                        transactionInfo.setCurrentSerial(this.currentSerial);
                    }
                    transactionInfo.setRequestHasContent(true);
                    transactionInfo.setRequestStatus(this.requestStatus);
                    transactionInfo.setRequestTransactionSerial(this.requestTransactionSerial);
                } else if (transactionInfo.getRequestStatus() != this.requestStatus) {
                    if (this.requestStatus == TransactionStatus.STATUS_SENT) {
                        transactionInfo.setCurrentSerial(this.currentSerial);
                    }
                    transactionInfo.setRequestStatus(this.requestStatus);
                }
                if (transactionInfo.getResponseTransactionSerial() != this.responseTransactionSerial) {
                    if (this.responseStatus != TransactionStatus.STATUS_INACTIVE) {
                        try {
                            transactionInfo.setFromResponse(this.currentTransaction.getResponse().getRawResponse());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            this.logger.log(Level.WARNING, "Error processing response, dropped transaction", uRISyntaxException);
                            this.handleBadUpdate(transactionInfo);
                            return;
                        }
                        if (this.responseStatus == TransactionStatus.STATUS_PENDING) {
                            transactionInfo.setCurrentSerial(this.currentSerial);
                        }
                        transactionInfo.setResponseHasContent(true);
                    } else {
                        transactionInfo.getResponseBuilder().clear();
                        transactionInfo.setResponseHasContent(false);
                    }
                    transactionInfo.setResponseStatus(this.responseStatus);
                    transactionInfo.setResponseTransactionSerial(this.responseTransactionSerial);
                } else if (transactionInfo.getResponseStatus() != this.responseStatus) {
                    transactionInfo.setResponseStatus(this.responseStatus);
                }
            } else {
                if (transactionInfo.getRequestTransactionSerial() != this.requestTransactionSerial) {
                    transactionInfo.getRequestBuilder().clear();
                    transactionInfo.setRequestHasContent(false);
                    transactionInfo.setRequestStatus(this.requestStatus);
                    transactionInfo.setRequestTransactionSerial(this.requestTransactionSerial);
                }
                if (transactionInfo.getResponseTransactionSerial() != this.responseTransactionSerial) {
                    transactionInfo.getResponseBuilder().clear();
                    transactionInfo.setResponseHasContent(false);
                    transactionInfo.setResponseStatus(this.responseStatus);
                    transactionInfo.setResponseTransactionSerial(this.responseTransactionSerial);
                }
            }
        }
    }

    private void handleBadUpdate(TransactionInfo transactionInfo) {
        this.currentTransaction.setEventHandler(null);
        this.currentTransaction.doDrop();
        this.getNextTransaction();
        this.updateTransactionInfo(transactionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionRequest(IProxyTransaction iProxyTransaction) {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (this.currentTransaction == null) {
                this.currentTransaction = iProxyTransaction;
                this.currentTransaction.setEventHandler(this.transactionEventHandler);
                ++this.requestTransactionSerial;
                this.setRequestPending();
                this.interceptView.notifyUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionResponse(IProxyTransaction iProxyTransaction) {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (this.currentTransaction == null || this.currentTransaction == iProxyTransaction) {
                if (this.currentTransaction == null) {
                    this.currentTransaction = iProxyTransaction;
                    this.currentTransaction.setEventHandler(this.transactionEventHandler);
                    ++this.requestTransactionSerial;
                }
                ++this.responseTransactionSerial;
                this.setResponsePending();
                this.interceptView.notifyUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionForward() {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (this.currentTransaction.hasResponse()) {
                this.currentTransaction.setEventHandler(null);
                this.getNextTransaction();
            } else {
                this.setRequestSent();
            }
            this.interceptView.notifyUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionComplete() {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            this.currentTransaction.setEventHandler(null);
            this.getNextTransaction();
            this.interceptView.notifyUpdate();
        }
    }

    private void getNextTransaction() {
        this.setCurrentTransaction(this.interceptor.transactionQueueGet(0));
    }

    private void setCurrentTransaction(IProxyTransaction iProxyTransaction) {
        this.currentTransaction = iProxyTransaction;
        ++this.requestTransactionSerial;
        ++this.responseTransactionSerial;
        if (this.currentTransaction != null) {
            this.currentTransaction.setEventHandler(this.transactionEventHandler);
            if (!this.currentTransaction.hasResponse()) {
                this.setRequestPending();
                this.setResponseInactive();
            } else {
                this.setResponsePending();
            }
        } else {
            this.setRequestInactive();
            this.setResponseInactive();
        }
    }

    private void setRequestPending() {
        this.currentRequestTransaction = this.currentTransaction;
        this.requestStatus = TransactionStatus.STATUS_PENDING;
        ++this.currentSerial;
    }

    private void setRequestInactive() {
        this.currentRequestTransaction = this.currentTransaction;
        this.requestStatus = TransactionStatus.STATUS_INACTIVE;
        ++this.currentSerial;
    }

    private void setRequestSent() {
        this.currentRequestTransaction = this.currentTransaction;
        this.requestStatus = TransactionStatus.STATUS_SENT;
        ++this.currentSerial;
    }

    private void setResponseInactive() {
        this.responseStatus = TransactionStatus.STATUS_INACTIVE;
        ++this.currentSerial;
    }

    private void setResponsePending() {
        this.responseStatus = TransactionStatus.STATUS_PENDING;
        ++this.currentSerial;
        if (this.currentRequestTransaction != this.currentTransaction) {
            this.setRequestSent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardTransaction(TransactionInfo transactionInfo) throws URISyntaxException, UnsupportedEncodingException {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (transactionInfo.getCurrentSerial() == this.currentSerial) {
                if (this.requestStatus == TransactionStatus.STATUS_PENDING) {
                    HttpUriRequest httpUriRequest = transactionInfo.getRequestBuilder().buildRequest(true);
                    this.currentTransaction.setRequest(httpUriRequest);
                    this.currentTransaction.doForward();
                } else if (this.responseStatus == TransactionStatus.STATUS_PENDING) {
                    HttpResponse httpResponse = transactionInfo.getResponseBuilder().buildResponse();
                    this.currentTransaction.getResponse().setRawResponse(httpResponse);
                    this.currentTransaction.doForward();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTransaction(TransactionInfo transactionInfo) {
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (transactionInfo.getCurrentSerial() == this.currentSerial) {
                ++this.currentSerial;
                this.currentTransaction.doDrop();
            }
        }
    }

    public static enum TransactionStatus {
        STATUS_INACTIVE,
        STATUS_PENDING,
        STATUS_SENT;

    }
}

