/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.intercept;

import com.subgraph.vega.api.http.requests.IHttpRequestBuilder;
import com.subgraph.vega.api.http.requests.IHttpResponseBuilder;
import com.subgraph.vega.ui.http.intercept.TransactionManager;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class TransactionInfo {
    private int currentSerial = -1;
    private int requestTransactionSerial = -1;
    private final IHttpRequestBuilder requestBuilder;
    private boolean requestHasContent;
    private TransactionManager.TransactionStatus requestStatus;
    private String requestStatusMessage;
    private int responseTransactionSerial;
    private final IHttpResponseBuilder responseBuilder;
    private boolean responseHasContent;
    private TransactionManager.TransactionStatus responseStatus;
    private String responseStatusMessage;

    public TransactionInfo(IHttpRequestBuilder iHttpRequestBuilder, IHttpResponseBuilder iHttpResponseBuilder) {
        this.requestBuilder = iHttpRequestBuilder;
        this.requestHasContent = false;
        this.setRequestStatus(TransactionManager.TransactionStatus.STATUS_INACTIVE);
        this.responseTransactionSerial = -1;
        this.responseBuilder = iHttpResponseBuilder;
        this.responseHasContent = false;
        this.setResponseStatus(TransactionManager.TransactionStatus.STATUS_INACTIVE);
    }

    public void setCurrentSerial(int n) {
        this.currentSerial = n;
    }

    public int getCurrentSerial() {
        return this.currentSerial;
    }

    public boolean isPending() {
        return this.requestStatus == TransactionManager.TransactionStatus.STATUS_PENDING || this.responseStatus == TransactionManager.TransactionStatus.STATUS_PENDING;
    }

    public void setRequestTransactionSerial(int n) {
        this.requestTransactionSerial = n;
    }

    public int getRequestTransactionSerial() {
        return this.requestTransactionSerial;
    }

    public void setFromRequest(HttpRequest httpRequest) throws URISyntaxException {
        this.requestBuilder.setFromRequest(httpRequest);
    }

    public IHttpRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void setRequestHasContent(boolean bl) {
        this.requestHasContent = bl;
    }

    public boolean requestHasContent() {
        return this.requestHasContent;
    }

    public void setRequestStatus(TransactionManager.TransactionStatus transactionStatus) {
        this.requestStatus = transactionStatus;
        switch (transactionStatus) {
            case STATUS_INACTIVE: {
                this.requestStatusMessage = "No request pending";
                break;
            }
            case STATUS_PENDING: {
                this.requestStatusMessage = "Request pending to " + this.getRequestHostPart();
                break;
            }
            case STATUS_SENT: {
                this.requestStatusMessage = "Request sent, awaiting response";
            }
        }
    }

    private String getRequestHostPart() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.requestBuilder.getScheme());
        stringBuilder.append("://");
        stringBuilder.append(this.requestBuilder.getHost());
        if (this.requestBuilder.getHostPort() != -1) {
            stringBuilder.append(':');
            stringBuilder.append(Integer.toString(this.requestBuilder.getHostPort()));
        }
        return stringBuilder.toString();
    }

    public TransactionManager.TransactionStatus getRequestStatus() {
        return this.requestStatus;
    }

    public boolean requestIsPending() {
        return this.requestStatus == TransactionManager.TransactionStatus.STATUS_PENDING;
    }

    public String getRequestStatusMessage() {
        return this.requestStatusMessage;
    }

    public void setResponseTransactionSerial(int n) {
        this.responseTransactionSerial = n;
    }

    public int getResponseTransactionSerial() {
        return this.responseTransactionSerial;
    }

    public void setFromResponse(HttpResponse httpResponse) throws URISyntaxException {
        this.responseBuilder.setFromResponse(httpResponse);
    }

    public IHttpResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    public void setResponseHasContent(boolean bl) {
        this.responseHasContent = bl;
    }

    public boolean responseHasContent() {
        return this.responseHasContent;
    }

    public void setResponseStatus(TransactionManager.TransactionStatus transactionStatus) {
        this.responseStatus = transactionStatus;
        switch (transactionStatus) {
            case STATUS_INACTIVE: {
                this.responseStatusMessage = "No response pending";
                break;
            }
            case STATUS_PENDING: {
                this.responseStatusMessage = "Response pending";
                break;
            }
            case STATUS_SENT: {
                break;
            }
        }
    }

    public TransactionManager.TransactionStatus getResponseStatus() {
        return this.responseStatus;
    }

    public boolean responseIsPending() {
        return this.responseStatus == TransactionManager.TransactionStatus.STATUS_PENDING;
    }

    public String getResponseStatusMessage() {
        return this.responseStatusMessage;
    }
}

