/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.conditions;

import com.subgraph.vega.api.model.conditions.match.IHttpConditionMatchAction;
import com.subgraph.vega.ui.http.conditions.MatchActionArgumentPanel;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class MatchActionComboViewer
extends ComboViewer {
    private MatchActionArgumentPanel argumentPanel;

    public MatchActionComboViewer(Composite composite) {
        super(composite, 8);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.addSelectionChangedListener(this.createSelectionChangedListener());
    }

    public void setMatchActionArgumentPanel(MatchActionArgumentPanel matchActionArgumentPanel) {
        this.argumentPanel = matchActionArgumentPanel;
        this.setArgumentPanelBySelection(this.getSelection());
    }

    private ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                return ((IHttpConditionMatchAction)object).getLabel();
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                MatchActionComboViewer.this.setArgumentPanelBySelection(selectionChangedEvent.getSelection());
            }
        };
    }

    public void reset() {
        Object object = this.getElementAt(0);
        if (object != null) {
            this.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    public void setMatchActionInput(List<IHttpConditionMatchAction> list) {
        this.setInput(list.toArray());
        this.reset();
    }

    public IHttpConditionMatchAction getSelectedMatchAction() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return null;
        }
        return (IHttpConditionMatchAction)iStructuredSelection.getFirstElement();
    }

    private void setArgumentPanelBySelection(ISelection iSelection) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (this.argumentPanel != null && !iStructuredSelection.isEmpty() && iStructuredSelection.getFirstElement() instanceof IHttpConditionMatchAction) {
            this.argumentPanel.displayPanelForMatchAction((IHttpConditionMatchAction)iStructuredSelection.getFirstElement());
        }
    }
}

