/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.ui.http.builder;

import com.subgraph.vega.api.http.requests.IHttpHeaderBuilder;
import com.subgraph.vega.api.http.requests.IHttpMessageBuilder;
import com.subgraph.vega.ui.http.builder.HeaderNameEditingSupport;
import com.subgraph.vega.ui.http.builder.HeaderTableContentProvider;
import com.subgraph.vega.ui.http.builder.HeaderValueEditingSupport;
import com.subgraph.vega.ui.http.builder.IHttpBuilderPart;
import java.util.Iterator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class HeaderEditor
extends Composite
implements IHttpBuilderPart {
    private IHttpMessageBuilder messageBuilder;
    private TableViewer tableViewerHeaders;
    private boolean headersTableHasSelection;
    private Button buttonCreate;
    private Button buttonRemove;
    private Button buttonMoveUp;
    private Button buttonMoveDown;
    private int heightInRows;

    public HeaderEditor(Composite composite, IHttpMessageBuilder iHttpMessageBuilder, int n) {
        super(composite, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.messageBuilder = iHttpMessageBuilder;
        this.heightInRows = n;
        GridData gridData = n != 0 ? new GridData(4, 0x1000000, true, false, 1, 1) : new GridData(4, 4, true, true, 1, 1);
        Composite composite2 = this.createHeaderTable(this, gridData, this.heightInRows);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = this.createHeaderTableButtons(this);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.tableViewerHeaders.setInput((Object)iHttpMessageBuilder);
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public void setEditable(boolean bl) {
        this.buttonCreate.setEnabled(bl);
        this.buttonRemove.setEnabled(bl && this.headersTableHasSelection);
        this.buttonMoveUp.setEnabled(bl && this.headersTableHasSelection);
        this.buttonMoveDown.setEnabled(bl && this.headersTableHasSelection);
    }

    @Override
    public void refresh() {
        this.tableViewerHeaders.refresh();
    }

    @Override
    public void processContents() {
    }

    private Composite createHeaderTable(Composite composite, GridData gridData, int n) {
        Composite composite2 = new Composite(composite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.tableViewerHeaders = new TableViewer(composite2, 68354);
        this.tableViewerHeaders.setContentProvider((IContentProvider)new HeaderTableContentProvider());
        this.tableViewerHeaders.addSelectionChangedListener(this.createSelectionChangedListener());
        this.createHeaderTableColumns(this.tableViewerHeaders, tableColumnLayout);
        Table table = this.tableViewerHeaders.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (n != 0) {
            gridData.heightHint = table.getItemHeight() * n;
        }
        return composite2;
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                HeaderEditor.this.headersTableHasSelection = !selectionChangedEvent.getSelection().isEmpty();
                HeaderEditor.this.buttonRemove.setEnabled(HeaderEditor.this.headersTableHasSelection);
                HeaderEditor.this.buttonMoveUp.setEnabled(HeaderEditor.this.headersTableHasSelection);
                HeaderEditor.this.buttonMoveDown.setEnabled(HeaderEditor.this.headersTableHasSelection);
            }
        };
    }

    private void createHeaderTableColumns(TableViewer tableViewer, TableColumnLayout tableColumnLayout) {
        String[] stringArray = new String[]{"Name", "Value"};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(120, true, true), new ColumnWeightData(100, 100, true)};
        EditingSupport[] editingSupportArray = new EditingSupport[]{new HeaderNameEditingSupport(tableViewer), new HeaderValueEditingSupport(tableViewer)};
        ColumnLabelProvider[] columnLabelProviderArray = new ColumnLabelProvider[]{new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpHeaderBuilder)object).getName();
            }
        }, new ColumnLabelProvider(){

            public String getText(Object object) {
                return ((IHttpHeaderBuilder)object).getValue();
            }
        }};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumnLayout.setColumnData((Widget)tableColumn, columnLayoutDataArray[n]);
            tableColumn.setText(stringArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setEditingSupport(editingSupportArray[n]);
            tableViewerColumn.setLabelProvider((CellLabelProvider)columnLabelProviderArray[n]);
            ++n;
        }
    }

    private Composite createHeaderTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.buttonCreate = new Button(composite2, 8);
        this.buttonCreate.setText("create");
        this.buttonCreate.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonCreate.addSelectionListener(this.createSelectionListenerButtonCreate());
        this.buttonRemove = new Button(composite2, 8);
        this.buttonRemove.setText("remove");
        this.buttonRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addSelectionListener(this.createSelectionListenerButtonRemove());
        this.buttonMoveUp = new Button(composite2, 8);
        this.buttonMoveUp.setText("move up");
        this.buttonMoveUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonMoveUp.setEnabled(false);
        this.buttonMoveUp.addSelectionListener(this.createSelectionListenerButtonMoveUp());
        this.buttonMoveDown = new Button(composite2, 8);
        this.buttonMoveDown.setText("move down");
        this.buttonMoveDown.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonMoveDown.setEnabled(false);
        this.buttonMoveDown.addSelectionListener(this.createSelectionListenerButtonMoveDown());
        return composite2;
    }

    private SelectionListener createSelectionListenerButtonCreate() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HeaderEditor.this.messageBuilder.addHeader("", "");
                HeaderEditor.this.tableViewerHeaders.refresh();
                HeaderEditor.this.tableViewerHeaders.editElement(HeaderEditor.this.tableViewerHeaders.getElementAt(HeaderEditor.this.tableViewerHeaders.getTable().getItemCount() - 1), 0);
            }
        };
    }

    private SelectionListener createSelectionListenerButtonRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)HeaderEditor.this.tableViewerHeaders.getSelection();
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    HeaderEditor.this.messageBuilder.removeHeader((IHttpHeaderBuilder)iterator.next());
                }
                HeaderEditor.this.tableViewerHeaders.refresh();
            }
        };
    }

    private SelectionListener createSelectionListenerButtonMoveUp() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)HeaderEditor.this.tableViewerHeaders.getSelection();
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    int n = HeaderEditor.this.messageBuilder.getHeaderIdxOf((IHttpHeaderBuilder)iterator.next());
                    if (n == 0) break;
                    HeaderEditor.this.messageBuilder.swapHeader(n - 1, n);
                }
                HeaderEditor.this.tableViewerHeaders.refresh();
            }
        };
    }

    private SelectionListener createSelectionListenerButtonMoveDown() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)HeaderEditor.this.tableViewerHeaders.getSelection();
                int[] nArray = new int[iStructuredSelection.size()];
                int n = 1;
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    nArray[nArray.length - n] = HeaderEditor.this.messageBuilder.getHeaderIdxOf((IHttpHeaderBuilder)iterator.next());
                    ++n;
                }
                if (nArray[0] + 1 != HeaderEditor.this.messageBuilder.getHeaderCnt()) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        HeaderEditor.this.messageBuilder.swapHeader(nArray[n2], nArray[n2] + 1);
                        ++n2;
                    }
                }
                HeaderEditor.this.tableViewerHeaders.refresh();
            }
        };
    }
}

